/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.query;

import com.google.common.base.Preconditions;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.query.RyaQueryOptions;

public class RyaQuery
extends RyaQueryOptions {
    private RyaStatement query;

    public RyaQuery(RyaStatement query) {
        Preconditions.checkNotNull((Object)query, (Object)"RyaStatement query cannot be null");
        this.query = query;
    }

    public static RyaQueryBuilder builder(RyaStatement query) {
        return new RyaQueryBuilder(query);
    }

    public RyaStatement getQuery() {
        return this.query;
    }

    public void setQuery(RyaStatement query) {
        this.query = query;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RyaQuery ryaQuery = (RyaQuery)o;
        return !(this.query != null ? !this.query.equals(ryaQuery.query) : ryaQuery.query != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RyaQuery{query=" + this.query + "options={" + super.toString() + '}' + '}';
    }

    public static class RyaQueryBuilder
    extends RyaQueryOptions.RyaOptionsBuilder<RyaQueryBuilder> {
        private RyaQuery ryaQuery;

        public RyaQueryBuilder(RyaStatement query) {
            this(new RyaQuery(query));
        }

        public RyaQueryBuilder(RyaQuery query) {
            super(query);
            this.ryaQuery = query;
        }

        public RyaQuery build() {
            return this.ryaQuery;
        }
    }
}

