/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.query.RyaQueryOptions;

public class BatchRyaQuery
extends RyaQueryOptions {
    private Iterable<RyaStatement> queries;
    private int maxRanges = 2;

    public BatchRyaQuery(Iterable<RyaStatement> queries) {
        Preconditions.checkNotNull(queries, (Object)"RyaStatement queries cannot be null");
        this.queries = queries;
    }

    public static RyaBatchQueryBuilder builder(Iterable<RyaStatement> queries) {
        return new RyaBatchQueryBuilder(queries);
    }

    public Iterable<RyaStatement> getQueries() {
        return this.queries;
    }

    public void setQueries(Iterable<RyaStatement> queries) {
        this.queries = queries;
    }

    public int getMaxRanges() {
        return this.maxRanges;
    }

    public void setMaxRanges(int maxRanges) {
        this.maxRanges = maxRanges;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BatchRyaQuery that = (BatchRyaQuery)o;
        return this.queries != null ? this.queries.equals(that.queries) : that.queries == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.queries != null ? this.queries.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "BatchRyaQuery{queries=" + Iterables.toString(this.queries) + "options={" + super.toString() + '}' + '}';
    }

    public static class RyaBatchQueryBuilder
    extends RyaQueryOptions.RyaOptionsBuilder<RyaBatchQueryBuilder> {
        private BatchRyaQuery ryaQuery;

        public RyaBatchQueryBuilder(Iterable<RyaStatement> queries) {
            this(new BatchRyaQuery(queries));
        }

        public RyaBatchQueryBuilder(BatchRyaQuery query) {
            super(query);
            this.ryaQuery = query;
        }

        public RyaBatchQueryBuilder setMaxRanges(int maxRanges) {
            this.ryaQuery.setMaxRanges(maxRanges);
            return this;
        }

        public BatchRyaQuery build() {
            return this.ryaQuery;
        }
    }
}

