/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.path;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class PathUtils {
    private PathUtils() {
    }

    public static java.nio.file.Path cleanPath(java.nio.file.Path path) {
        if (path != null) {
            java.nio.file.Path cleanPath = PathUtils.cleanPath(path.toString());
            return cleanPath;
        }
        return null;
    }

    public static java.nio.file.Path cleanPath(String filename) {
        if (filename != null) {
            java.nio.file.Path cleanPath = Paths.get(PathUtils.clean(filename), new String[0]);
            return cleanPath;
        }
        return null;
    }

    public static Path cleanHadoopPath(Path hadoopPath, Configuration conf) throws IllegalArgumentException, IOException {
        if (hadoopPath != null) {
            java.nio.file.Path path = PathUtils.fromHadoopPath(hadoopPath, conf);
            java.nio.file.Path clean = PathUtils.cleanPath(path);
            return PathUtils.toHadoopPath(clean);
        }
        return null;
    }

    public static String clean(String filename) throws IllegalArgumentException {
        if (filename != null) {
            String clean = FilenameUtils.normalize((String)filename);
            if (!PathUtils.isInSecureDir(clean)) {
                throw new IllegalArgumentException("Operation of a file in a shared directory is not allowed: " + filename);
            }
            return clean;
        }
        return null;
    }

    public static boolean isInSecureDir(String filename) {
        java.nio.file.Path path = filename != null ? Paths.get(filename, new String[0]) : null;
        return PathUtils.isInSecureDir(path, null);
    }

    public static boolean isInSecureDir(java.nio.file.Path file) {
        return PathUtils.isInSecureDir(file, null);
    }

    public static boolean isInSecureDir(java.nio.file.Path file, UserPrincipal user) {
        return PathUtils.isInSecureDir(file, user, 5);
    }

    public static boolean isInSecureDir(java.nio.file.Path file, UserPrincipal user, int symlinkDepth) {
        if (!file.isAbsolute()) {
            file = file.toAbsolutePath();
        }
        if (symlinkDepth <= 0) {
            return false;
        }
        java.nio.file.Path fileRoot = file.getRoot();
        if (fileRoot == null) {
            return false;
        }
        java.nio.file.FileSystem fileSystem = Paths.get(fileRoot.toString(), new String[0]).getFileSystem();
        UserPrincipalLookupService upls = fileSystem.getUserPrincipalLookupService();
        UserPrincipal root = null;
        try {
            root = SystemUtils.IS_OS_UNIX ? upls.lookupPrincipalByName("root") : upls.lookupPrincipalByName("Administrators");
            if (user == null) {
                user = upls.lookupPrincipalByName(System.getProperty("user.name"));
            }
            if (root == null || user == null) {
                return false;
            }
        }
        catch (IOException x) {
            return false;
        }
        for (int i = 1; i <= file.getNameCount(); ++i) {
            java.nio.file.Path partialPath = Paths.get(fileRoot.toString(), file.subpath(0, i).toString());
            try {
                if (Files.isSymbolicLink(partialPath)) {
                    if (PathUtils.isInSecureDir(Files.readSymbolicLink(partialPath), user, symlinkDepth - 1)) continue;
                    return false;
                }
                UserPrincipal owner = Files.getOwner(partialPath, new LinkOption[0]);
                if (user.equals(owner) || root.equals(owner)) continue;
                return SystemUtils.IS_OS_UNIX ? false : Files.isWritable(partialPath);
            }
            catch (IOException x) {
                return false;
            }
        }
        return true;
    }

    public static Path toHadoopPath(String filename) {
        if (filename != null) {
            java.nio.file.Path path = Paths.get(filename, new String[0]);
            return PathUtils.toHadoopPath(path);
        }
        return null;
    }

    public static Path toHadoopPath(java.nio.file.Path path) {
        if (path != null) {
            String stringPath = FilenameUtils.separatorsToUnix((String)path.toAbsolutePath().toString());
            Path hadoopPath = new Path(stringPath);
            return hadoopPath;
        }
        return null;
    }

    public static java.nio.file.Path fromHadoopPath(Path hadoopPath, Configuration conf) throws IOException {
        if (hadoopPath != null) {
            FileSystem fs = FileSystem.get((URI)hadoopPath.toUri(), (Configuration)conf);
            File tempFile = File.createTempFile(hadoopPath.getName(), "");
            tempFile.deleteOnExit();
            fs.copyToLocalFile(hadoopPath, new Path(tempFile.getAbsolutePath()));
            return tempFile.toPath();
        }
        return null;
    }
}

