/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.instance;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class RyaDetailsUpdater {
    private static final Logger log = LoggerFactory.getLogger(RyaDetailsUpdater.class);
    private final RyaDetailsRepository repo;

    public RyaDetailsUpdater(RyaDetailsRepository repo) {
        this.repo = Objects.requireNonNull(repo);
    }

    public void update(RyaDetailsMutator mutator) throws RyaDetailsRepository.RyaDetailsRepositoryException, RyaDetailsMutator.CouldNotApplyMutationException {
        Objects.requireNonNull(mutator);
        boolean updated = false;
        while (!updated) {
            try {
                RyaDetails original = this.repo.getRyaInstanceDetails();
                RyaDetails mutated = mutator.mutate(original);
                this.repo.update(original, mutated);
                updated = true;
            }
            catch (RyaDetailsRepository.ConcurrentUpdateException e) {
                log.debug("Failed to update the details because another application changed them. Trying again.", (Throwable)e);
            }
        }
    }

    @DefaultAnnotation(value={NonNull.class})
    public static interface RyaDetailsMutator {
        public RyaDetails mutate(RyaDetails var1) throws CouldNotApplyMutationException;

        public static class CouldNotApplyMutationException
        extends Exception {
            private static final long serialVersionUID = 1L;

            public CouldNotApplyMutationException(String message) {
                super(message);
            }
        }
    }
}

