/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.instance;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.api.instance.RyaDetails;

@DefaultAnnotation(value={NonNull.class})
public class RyaDetailsToConfiguration {
    private static final Logger log = Logger.getLogger(RyaDetailsToConfiguration.class);

    public static void addRyaDetailsToConfiguration(RyaDetails details, Configuration conf) {
        Objects.requireNonNull(details);
        Objects.requireNonNull(conf);
        RyaDetailsToConfiguration.checkAndSet(conf, "sc.use_entity", details.getEntityCentricIndexDetails().isEnabled());
        RyaDetailsToConfiguration.checkAndSet(conf, "sc.use_freetext", details.getFreeTextIndexDetails().isEnabled());
        RyaDetailsToConfiguration.checkAndSet(conf, "sc.use_temporal", details.getTemporalIndexDetails().isEnabled());
        RyaDetails.PCJIndexDetails pcjDetails = details.getPCJIndexDetails();
        if (conf.getBoolean("sc.useMongo", false)) {
            if (pcjDetails.isEnabled()) {
                conf.set("rya.indexing.pcj.storageType", "MONGO");
                RyaDetailsToConfiguration.checkAndSet(conf, "sc.use.updater", false);
                conf.set("rya.indexing.pcj.updaterType", "NO_UPDATE");
            }
        } else if (pcjDetails.isEnabled()) {
            conf.set("rya.indexing.pcj.storageType", "ACCUMULO");
            if (pcjDetails.getFluoDetails().isPresent()) {
                RyaDetailsToConfiguration.checkAndSet(conf, "sc.use.updater", true);
                conf.set("rya.indexing.pcj.fluo.fluoAppName", ((RyaDetails.PCJIndexDetails.FluoDetails)pcjDetails.getFluoDetails().get()).getUpdateAppName());
                conf.set("rya.indexing.pcj.updaterType", "FLUO");
            } else {
                RyaDetailsToConfiguration.checkAndSet(conf, "sc.use.updater", false);
                conf.set("rya.indexing.pcj.updaterType", "NO_UPDATE");
            }
        }
    }

    private static void checkAndSet(Configuration conf, String useIndexField, boolean indexSupported) {
        Objects.requireNonNull(conf);
        Objects.requireNonNull(useIndexField);
        Optional useIndexStr = Optional.fromNullable((Object)conf.get(useIndexField));
        if (!useIndexStr.isPresent()) {
            log.info((Object)("No Rya Client configuration was provided for the " + useIndexField + " index, so it is being defaulted to " + indexSupported));
            conf.setBoolean(useIndexField, indexSupported);
            return;
        }
        boolean useIndex = Boolean.parseBoolean((String)useIndexStr.get());
        if (useIndex && !indexSupported) {
            log.warn((Object)("The Rya Client indicates it wants to use a secondary index that the Rya Instance does not support. This is not allowed, so the index will be turned off. Index Configuration Field: " + useIndexField));
            conf.setBoolean(useIndexField, false);
        }
    }
}

