/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.instance;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.rya.api.instance.RyaDetails;

@DefaultAnnotation(value={NonNull.class})
public interface RyaDetailsRepository {
    public boolean isInitialized() throws RyaDetailsRepositoryException;

    public void initialize(RyaDetails var1) throws AlreadyInitializedException, RyaDetailsRepositoryException;

    public RyaDetails getRyaInstanceDetails() throws NotInitializedException, RyaDetailsRepositoryException;

    public void update(RyaDetails var1, RyaDetails var2) throws NotInitializedException, ConcurrentUpdateException, RyaDetailsRepositoryException;

    public static class ConcurrentUpdateException
    extends RyaDetailsRepositoryException {
        private static final long serialVersionUID = 1L;

        public ConcurrentUpdateException(String message) {
            super(message);
        }
    }

    public static class NotInitializedException
    extends RyaDetailsRepositoryException {
        private static final long serialVersionUID = 1L;

        public NotInitializedException(String message) {
            super(message);
        }

        public NotInitializedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AlreadyInitializedException
    extends RyaDetailsRepositoryException {
        private static final long serialVersionUID = 1L;

        public AlreadyInitializedException(String message) {
            super(message);
        }
    }

    public static class RyaDetailsRepositoryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RyaDetailsRepositoryException(String message) {
            super(message);
        }

        public RyaDetailsRepositoryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

