/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.instance;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class RyaDetails
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String instanceName;
    private final String version;
    private final ImmutableList<String> users;
    private final EntityCentricIndexDetails entityCentricDetails;
    private final PCJIndexDetails pcjDetails;
    private final TemporalIndexDetails temporalDetails;
    private final FreeTextIndexDetails freeTextDetails;
    private final ProspectorDetails prospectorDetails;
    private final JoinSelectivityDetails joinSelectivityDetails;
    private final Optional<RyaStreamsDetails> ryaStreamsDetails;

    private RyaDetails(String instanceName, String version, ImmutableList<String> users, EntityCentricIndexDetails entityCentricDetails, PCJIndexDetails pcjDetails, TemporalIndexDetails temporalDetails, FreeTextIndexDetails freeTextDetails, ProspectorDetails prospectorDetails, JoinSelectivityDetails joinSelectivityDetails, Optional<RyaStreamsDetails> ryaStreamsDetails) {
        this.instanceName = Objects.requireNonNull(instanceName);
        this.version = Objects.requireNonNull(version);
        this.users = Objects.requireNonNull(users);
        this.entityCentricDetails = Objects.requireNonNull(entityCentricDetails);
        this.pcjDetails = Objects.requireNonNull(pcjDetails);
        this.temporalDetails = Objects.requireNonNull(temporalDetails);
        this.freeTextDetails = Objects.requireNonNull(freeTextDetails);
        this.prospectorDetails = Objects.requireNonNull(prospectorDetails);
        this.joinSelectivityDetails = Objects.requireNonNull(joinSelectivityDetails);
        this.ryaStreamsDetails = Objects.requireNonNull(ryaStreamsDetails);
    }

    public String getRyaInstanceName() {
        return this.instanceName;
    }

    public String getRyaVersion() {
        return this.version;
    }

    public ImmutableList<String> getUsers() {
        return this.users;
    }

    public EntityCentricIndexDetails getEntityCentricIndexDetails() {
        return this.entityCentricDetails;
    }

    public PCJIndexDetails getPCJIndexDetails() {
        return this.pcjDetails;
    }

    public TemporalIndexDetails getTemporalIndexDetails() {
        return this.temporalDetails;
    }

    public FreeTextIndexDetails getFreeTextIndexDetails() {
        return this.freeTextDetails;
    }

    public ProspectorDetails getProspectorDetails() {
        return this.prospectorDetails;
    }

    public JoinSelectivityDetails getJoinSelectivityDetails() {
        return this.joinSelectivityDetails;
    }

    public Optional<RyaStreamsDetails> getRyaStreamsDetails() {
        return this.ryaStreamsDetails;
    }

    public int hashCode() {
        return Objects.hash(this.instanceName, this.version, this.entityCentricDetails, this.pcjDetails, this.temporalDetails, this.freeTextDetails, this.prospectorDetails, this.joinSelectivityDetails, this.ryaStreamsDetails);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RyaDetails) {
            RyaDetails details = (RyaDetails)obj;
            return Objects.equals(this.instanceName, details.instanceName) && Objects.equals(this.version, details.version) && Objects.equals(this.entityCentricDetails, details.entityCentricDetails) && Objects.equals(this.pcjDetails, details.pcjDetails) && Objects.equals(this.temporalDetails, details.temporalDetails) && Objects.equals(this.freeTextDetails, details.freeTextDetails) && Objects.equals(this.prospectorDetails, details.prospectorDetails) && Objects.equals(this.joinSelectivityDetails, details.joinSelectivityDetails) && Objects.equals(this.ryaStreamsDetails, details.ryaStreamsDetails);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RyaDetails details) {
        return new Builder(details);
    }

    public static class RyaStreamsDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String hostname;
        private final int port;

        public RyaStreamsDetails(String hostname, int port) {
            this.hostname = Objects.requireNonNull(hostname);
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return Objects.hash(this.hostname, this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RyaStreamsDetails) {
                RyaStreamsDetails other = (RyaStreamsDetails)obj;
                return Objects.equals(this.hostname, other.hostname) && this.port == other.port;
            }
            return false;
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class JoinSelectivityDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Optional<Date> lastUpdated;

        public JoinSelectivityDetails(Optional<Date> lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated);
        }

        public Optional<Date> getLastUpdated() {
            return this.lastUpdated;
        }

        public int hashCode() {
            return Objects.hash(this.lastUpdated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JoinSelectivityDetails) {
                JoinSelectivityDetails details = (JoinSelectivityDetails)obj;
                return Objects.equals(this.lastUpdated, details.lastUpdated);
            }
            return false;
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class ProspectorDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Optional<Date> lastUpdated;

        public ProspectorDetails(Optional<Date> lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated);
        }

        public Optional<Date> getLastUpdated() {
            return this.lastUpdated;
        }

        public int hashCode() {
            return Objects.hash(this.lastUpdated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ProspectorDetails) {
                ProspectorDetails details = (ProspectorDetails)obj;
                return Objects.equals(this.lastUpdated, details.lastUpdated);
            }
            return false;
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class PCJIndexDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final boolean enabled;
        private final Optional<FluoDetails> fluoDetails;
        private final ImmutableMap<String, PCJDetails> pcjDetails;

        private PCJIndexDetails(boolean enabled, Optional<FluoDetails> fluoDetails, ImmutableMap<String, PCJDetails> pcjDetails) {
            this.enabled = enabled;
            this.fluoDetails = Objects.requireNonNull(fluoDetails);
            this.pcjDetails = Objects.requireNonNull(pcjDetails);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Optional<FluoDetails> getFluoDetails() {
            return this.fluoDetails;
        }

        public ImmutableMap<String, PCJDetails> getPCJDetails() {
            return this.pcjDetails;
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.fluoDetails, this.pcjDetails);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PCJIndexDetails) {
                PCJIndexDetails details = (PCJIndexDetails)obj;
                return Objects.equals(this.enabled, details.enabled) && Objects.equals(this.fluoDetails, details.fluoDetails) && Objects.equals(this.pcjDetails, details.pcjDetails);
            }
            return false;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(PCJIndexDetails pcjIndexDetails) {
            return new Builder(pcjIndexDetails);
        }

        @Immutable
        @DefaultAnnotation(value={NonNull.class})
        public static class PCJDetails
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final String id;
            private final Optional<PCJUpdateStrategy> updateStrategy;
            private final Optional<Date> lastUpdateTime;

            private PCJDetails(String id, Optional<PCJUpdateStrategy> updateStrategy, Optional<Date> lastUpdateTime) {
                this.id = Objects.requireNonNull(id);
                this.updateStrategy = Objects.requireNonNull(updateStrategy);
                this.lastUpdateTime = Objects.requireNonNull(lastUpdateTime);
            }

            public String getId() {
                return this.id;
            }

            public Optional<PCJUpdateStrategy> getUpdateStrategy() {
                return this.updateStrategy;
            }

            public Optional<Date> getLastUpdateTime() {
                return this.lastUpdateTime;
            }

            public int hashCode() {
                return Objects.hash(this.id, this.updateStrategy, this.lastUpdateTime);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof PCJDetails) {
                    PCJDetails details = (PCJDetails)obj;
                    return Objects.equals(this.id, details.id) && Objects.equals(this.updateStrategy, details.updateStrategy) && Objects.equals(this.lastUpdateTime, details.lastUpdateTime);
                }
                return false;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static Builder builder(PCJDetails details) {
                return new Builder(details);
            }

            public static enum PCJUpdateStrategy {
                BATCH,
                INCREMENTAL;

            }

            @DefaultAnnotation(value={NonNull.class})
            public static class Builder {
                private String id;
                private PCJUpdateStrategy updateStrategy;
                private Date lastUpdateTime;

                public Builder() {
                }

                public Builder(PCJDetails details) {
                    Objects.requireNonNull(details);
                    this.id = details.id;
                    this.updateStrategy = (PCJUpdateStrategy)((Object)details.updateStrategy.orNull());
                    this.lastUpdateTime = (Date)details.lastUpdateTime.orNull();
                }

                @Nullable
                public String getId() {
                    return this.id;
                }

                public Builder setId(@Nullable String id) {
                    this.id = id;
                    return this;
                }

                public PCJUpdateStrategy getUpdateStrategy() {
                    return this.updateStrategy;
                }

                public Builder setUpdateStrategy(@Nullable PCJUpdateStrategy updateStrategy) {
                    this.updateStrategy = updateStrategy;
                    return this;
                }

                @Nullable
                public Date getLastUpdateTime() {
                    return this.lastUpdateTime;
                }

                public Builder setLastUpdateTime(@Nullable Date lastUpdateTime) {
                    this.lastUpdateTime = lastUpdateTime;
                    return this;
                }

                public PCJDetails build() {
                    return new PCJDetails(this.id, Optional.fromNullable((Object)((Object)this.updateStrategy)), Optional.fromNullable((Object)this.lastUpdateTime));
                }
            }
        }

        @Immutable
        @DefaultAnnotation(value={NonNull.class})
        public static class FluoDetails
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final String updateAppName;

            public FluoDetails(String updateAppName) {
                this.updateAppName = Objects.requireNonNull(updateAppName);
            }

            public String getUpdateAppName() {
                return this.updateAppName;
            }

            public int hashCode() {
                return Objects.hash(this.updateAppName);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof FluoDetails) {
                    FluoDetails details = (FluoDetails)obj;
                    return Objects.equals(this.updateAppName, details.updateAppName);
                }
                return false;
            }
        }

        @DefaultAnnotation(value={NonNull.class})
        public static class Builder {
            private Boolean enabled = null;
            private FluoDetails fluoDetails = null;
            private final Map<String, PCJDetails.Builder> pcjDetailsBuilders = new HashMap<String, PCJDetails.Builder>();

            public Builder() {
            }

            public Builder(PCJIndexDetails pcjIndexDetails) {
                Objects.requireNonNull(pcjIndexDetails);
                this.enabled = pcjIndexDetails.enabled;
                this.fluoDetails = (FluoDetails)pcjIndexDetails.fluoDetails.orNull();
                for (PCJDetails pcjDetails : pcjIndexDetails.pcjDetails.values()) {
                    this.pcjDetailsBuilders.put(pcjDetails.getId(), PCJDetails.builder(pcjDetails));
                }
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder setFluoDetails(@Nullable FluoDetails fluoDetails) {
                this.fluoDetails = fluoDetails;
                return this;
            }

            public Builder addPCJDetails(@Nullable PCJDetails.Builder pcjDetailsBuilder) {
                if (pcjDetailsBuilder != null) {
                    this.pcjDetailsBuilders.put(pcjDetailsBuilder.getId(), pcjDetailsBuilder);
                }
                return this;
            }

            public Builder removePCJDetails(@Nullable String pcjId) {
                Objects.requireNonNull(pcjId);
                this.pcjDetailsBuilders.remove(pcjId);
                return this;
            }

            public PCJIndexDetails build() {
                ImmutableMap.Builder pcjDetails = ImmutableMap.builder();
                for (Map.Entry<String, PCJDetails.Builder> entry : this.pcjDetailsBuilders.entrySet()) {
                    pcjDetails.put((Object)entry.getKey(), (Object)entry.getValue().build());
                }
                return new PCJIndexDetails(this.enabled, Optional.fromNullable((Object)this.fluoDetails), pcjDetails.build());
            }
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class FreeTextIndexDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean enabled;

        public FreeTextIndexDetails(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FreeTextIndexDetails) {
                FreeTextIndexDetails details = (FreeTextIndexDetails)obj;
                return this.enabled == details.enabled;
            }
            return false;
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class EntityCentricIndexDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean enabled;

        public EntityCentricIndexDetails(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EntityCentricIndexDetails) {
                EntityCentricIndexDetails details = (EntityCentricIndexDetails)obj;
                return this.enabled == details.enabled;
            }
            return false;
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class TemporalIndexDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean enabled;

        public TemporalIndexDetails(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TemporalIndexDetails) {
                TemporalIndexDetails details = (TemporalIndexDetails)obj;
                return this.enabled == details.enabled;
            }
            return false;
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class GeoIndexDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean enabled;

        public GeoIndexDetails(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof GeoIndexDetails) {
                GeoIndexDetails details = (GeoIndexDetails)obj;
                return this.enabled == details.enabled;
            }
            return false;
        }
    }

    @DefaultAnnotation(value={NonNull.class})
    public static class Builder {
        private String instanceName;
        private String version;
        private final List<String> users = new ArrayList<String>();
        private EntityCentricIndexDetails entityCentricDetails;
        private GeoIndexDetails geoDetails;
        private PCJIndexDetails.Builder pcjIndexDetailsBuilder;
        private TemporalIndexDetails temporalDetails;
        private FreeTextIndexDetails freeTextDetails;
        private ProspectorDetails prospectorDetails;
        private JoinSelectivityDetails joinSelectivityDetails;
        private RyaStreamsDetails ryaStreamsDetails;

        public Builder() {
        }

        public Builder(RyaDetails details) {
            Objects.requireNonNull(details);
            this.instanceName = details.instanceName;
            this.version = details.version;
            this.users.addAll((Collection<String>)details.users);
            this.entityCentricDetails = details.entityCentricDetails;
            this.pcjIndexDetailsBuilder = PCJIndexDetails.builder(details.pcjDetails);
            this.temporalDetails = details.temporalDetails;
            this.freeTextDetails = details.freeTextDetails;
            this.prospectorDetails = details.prospectorDetails;
            this.joinSelectivityDetails = details.joinSelectivityDetails;
            this.ryaStreamsDetails = (RyaStreamsDetails)details.ryaStreamsDetails.orNull();
        }

        public Builder setRyaInstanceName(@Nullable String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public Builder setRyaVersion(@Nullable String version) {
            this.version = version;
            return this;
        }

        public Builder addUser(String user) {
            this.users.add(user);
            return this;
        }

        public Builder removeUser(String user) {
            this.users.remove(user);
            return this;
        }

        public Builder setEntityCentricIndexDetails(@Nullable EntityCentricIndexDetails entityCentricDetails) {
            this.entityCentricDetails = entityCentricDetails;
            return this;
        }

        public Builder setTemporalIndexDetails(@Nullable TemporalIndexDetails temporalDetails) {
            this.temporalDetails = temporalDetails;
            return this;
        }

        public Builder setFreeTextDetails(@Nullable FreeTextIndexDetails freeTextDetails) {
            this.freeTextDetails = freeTextDetails;
            return this;
        }

        public Builder setPCJIndexDetails(@Nullable PCJIndexDetails.Builder pcjDetailsBuilder) {
            this.pcjIndexDetailsBuilder = pcjDetailsBuilder;
            return this;
        }

        @Nullable
        public PCJIndexDetails.Builder getPCJIndexDetails() {
            return this.pcjIndexDetailsBuilder;
        }

        public Builder setProspectorDetails(@Nullable ProspectorDetails prospectorDetails) {
            this.prospectorDetails = prospectorDetails;
            return this;
        }

        public Builder setJoinSelectivityDetails(@Nullable JoinSelectivityDetails joinSelectivityDetails) {
            this.joinSelectivityDetails = joinSelectivityDetails;
            return this;
        }

        public Builder setRyaStreamsDetails(@Nullable RyaStreamsDetails ryaStreamsDetails) {
            this.ryaStreamsDetails = ryaStreamsDetails;
            return this;
        }

        public RyaDetails build() {
            return new RyaDetails(this.instanceName, this.version, ImmutableList.copyOf(this.users), this.entityCentricDetails, this.pcjIndexDetailsBuilder.build(), this.temporalDetails, this.freeTextDetails, this.prospectorDetails, this.joinSelectivityDetails, Optional.fromNullable((Object)this.ryaStreamsDetails));
        }
    }
}

