/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.functions;

import com.google.common.base.Preconditions;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class OWLTime {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    public static final String NAMESPACE = "http://www.w3.org/2006/time#";
    public static final IRI SECONDS_URI = VF.createIRI("http://www.w3.org/2006/time#", "seconds");
    public static final IRI MINUTES_URI = VF.createIRI("http://www.w3.org/2006/time#", "minutes");
    public static final IRI HOURS_URI = VF.createIRI("http://www.w3.org/2006/time#", "hours");
    public static final IRI DAYS_URI = VF.createIRI("http://www.w3.org/2006/time#", "days");
    public static final IRI WEEKS_URI = VF.createIRI("http://www.w3.org/2006/time#", "weeks");
    private static final Map<IRI, ChronoUnit> DURATION_MAP = new HashMap<IRI, ChronoUnit>();

    public static boolean isValidDurationType(IRI durationIRI) {
        Preconditions.checkNotNull((Object)durationIRI);
        return DURATION_MAP.containsKey(durationIRI);
    }

    public static long getMillis(int duration, IRI iri) throws IllegalArgumentException {
        Optional<ChronoUnit> unit = OWLTime.getChronoUnitFromURI(iri);
        Preconditions.checkArgument((boolean)unit.isPresent(), (Object)String.format("IRI %s does not indicate a valid OWLTime time unit.  IRI must of be of type %s, %s, %s, %s, or %s .", iri, SECONDS_URI, MINUTES_URI, HOURS_URI, DAYS_URI, WEEKS_URI));
        return (long)duration * unit.get().getDuration().toMillis();
    }

    public static Optional<ChronoUnit> getChronoUnitFromURI(IRI durationIRI) {
        return Optional.ofNullable(DURATION_MAP.get(durationIRI));
    }

    static {
        DURATION_MAP.put(SECONDS_URI, ChronoUnit.SECONDS);
        DURATION_MAP.put(MINUTES_URI, ChronoUnit.MINUTES);
        DURATION_MAP.put(HOURS_URI, ChronoUnit.HOURS);
        DURATION_MAP.put(DAYS_URI, ChronoUnit.DAYS);
        DURATION_MAP.put(WEEKS_URI, ChronoUnit.WEEKS);
    }
}

