/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.functions;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import org.apache.rya.api.functions.OWLTime;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class DateTimeWithinPeriod
implements Function {
    private static final String FUNCTION_IRI = "http://www.w3.org/2005/xpath-functions#dateTimeWithin";

    public String getURI() {
        return FUNCTION_IRI;
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        Preconditions.checkNotNull((Object)valueFactory);
        Preconditions.checkNotNull((Object)values);
        try {
            Preconditions.checkArgument((values.length == 4 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)(values[0] instanceof Literal));
            Preconditions.checkArgument((boolean)(values[1] instanceof Literal));
            Preconditions.checkArgument((boolean)(values[2] instanceof Literal));
            Preconditions.checkArgument((boolean)(values[3] instanceof IRI));
            Instant dateTime1 = this.convertToInstant((Literal)values[0]);
            Instant dateTime2 = this.convertToInstant((Literal)values[1]);
            long periodMillis = this.convertPeriodToMillis((Literal)values[2], (IRI)values[3]);
            long timeBetween = Math.abs(Duration.between(dateTime1, dateTime2).toMillis());
            return valueFactory.createLiteral(timeBetween < periodMillis);
        }
        catch (Exception e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }

    private Instant convertToInstant(Literal literal) {
        String stringVal = literal.getLabel();
        IRI dataType = literal.getDatatype();
        Preconditions.checkArgument((dataType.equals((Object)XMLSchema.DATETIME) || dataType.equals((Object)XMLSchema.DATE) ? 1 : 0) != 0, (Object)String.format("Invalid data type for date time. Data Type must be of type %s or %s .", XMLSchema.DATETIME, XMLSchema.DATE));
        Preconditions.checkArgument((XMLDatatypeUtil.isValidDateTime((String)stringVal) || XMLDatatypeUtil.isValidDate((String)stringVal) ? 1 : 0) != 0, (Object)"Invalid date time value.");
        return literal.calendarValue().toGregorianCalendar().toInstant();
    }

    private long convertPeriodToMillis(Literal literal, IRI unit) {
        String stringVal = literal.getLabel();
        IRI dataType = literal.getDatatype();
        Preconditions.checkArgument((dataType.equals((Object)XMLSchema.INTEGER) || dataType.equals((Object)XMLSchema.INT) ? 1 : 0) != 0, (Object)String.format("Invalid data type for period duration. Data Type must be of type %s or %s .", XMLSchema.INTEGER, XMLSchema.INT));
        Preconditions.checkArgument((XMLDatatypeUtil.isValidInteger((String)stringVal) || XMLDatatypeUtil.isValidInt((String)stringVal) ? 1 : 0) != 0, (Object)"Invalid duration value.");
        return this.convertToMillis(Integer.parseInt(stringVal), unit);
    }

    private long convertToMillis(int duration, IRI unit) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0);
        return OWLTime.getMillis(duration, unit);
    }
}

