/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.domain.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class RyaStatementSerializer
extends Serializer<RyaStatement> {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    public static void writeToKryo(Kryo kryo, Output output, RyaStatement object) {
        Preconditions.checkNotNull((Object)kryo);
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull((Object)object);
        output.writeString(object.getSubject().getData());
        output.writeString(object.getPredicate().getData());
        output.writeString(object.getObject().getDataType().toString());
        output.writeString(object.getObject().getData());
        boolean hasContext = object.getContext() != null;
        output.writeBoolean(hasContext);
        if (hasContext) {
            output.writeString(object.getContext().getData());
        }
        boolean shouldWrite = object.getColumnVisibility() != null;
        output.writeBoolean(shouldWrite);
        if (shouldWrite) {
            output.writeInt(object.getColumnVisibility().length);
            output.writeBytes(object.getColumnVisibility());
        }
        shouldWrite = object.getQualifer() != null;
        output.writeBoolean(shouldWrite);
        if (shouldWrite) {
            output.writeString(object.getQualifer());
        }
        shouldWrite = object.getTimestamp() != null;
        output.writeBoolean(shouldWrite);
        if (shouldWrite) {
            output.writeLong(object.getTimestamp().longValue());
        }
        shouldWrite = object.getValue() != null;
        output.writeBoolean(shouldWrite);
        if (shouldWrite) {
            output.writeBytes(object.getValue());
        }
    }

    public void write(Kryo kryo, Output output, RyaStatement object) {
        RyaStatementSerializer.writeToKryo(kryo, output, object);
    }

    public static RyaStatement readFromKryo(Kryo kryo, Input input, Class<RyaStatement> type) {
        return RyaStatementSerializer.read(input);
    }

    public static RyaStatement read(Input input) {
        Preconditions.checkNotNull((Object)input);
        String subject = input.readString();
        String predicate = input.readString();
        String objectType = input.readString();
        String objectValue = input.readString();
        RyaType value = objectType.equals(XMLSchema.ANYURI.toString()) ? new RyaIRI(objectValue) : new RyaType(VF.createIRI(objectType), objectValue);
        RyaStatement statement = new RyaStatement(new RyaIRI(subject), new RyaIRI(predicate), value);
        int length = 0;
        boolean hasNextValue = input.readBoolean();
        if (hasNextValue) {
            statement.setContext(new RyaIRI(input.readString()));
        }
        if (hasNextValue = input.readBoolean()) {
            length = input.readInt();
            statement.setColumnVisibility(input.readBytes(length));
        }
        if (hasNextValue = input.readBoolean()) {
            statement.setQualifer(input.readString());
        }
        if (hasNextValue = input.readBoolean()) {
            statement.setTimestamp(input.readLong());
        }
        if (hasNextValue = input.readBoolean()) {
            length = input.readInt();
            statement.setValue(input.readBytes(length));
        }
        return statement;
    }

    public RyaStatement read(Kryo kryo, Input input, Class<RyaStatement> type) {
        return RyaStatementSerializer.readFromKryo(kryo, input, type);
    }
}

