/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.domain;

import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;

public final class VarNameUtils {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    public static final String CONSTANT_PREFIX = "_const_";
    private static final String LEGACY_CONSTANT_PREFIX = "-const-";
    public static final String ANONYMOUS_PREFIX = "_anon_";
    private static final String LEGACY_ANONYMOUS_PREFIX = "-anon-";

    private VarNameUtils() {
    }

    @Nullable
    public static String prependConstant(@Nullable String value) {
        if (value != null) {
            return CONSTANT_PREFIX + value;
        }
        return null;
    }

    public static boolean isConstant(@Nullable String name) {
        if (name != null) {
            return name.startsWith(CONSTANT_PREFIX) || name.startsWith(LEGACY_CONSTANT_PREFIX);
        }
        return false;
    }

    @Nullable
    public static String removeConstant(@Nullable String name) {
        if (VarNameUtils.isConstant(name)) {
            String removed = StringUtils.removeStart((String)name, (String)CONSTANT_PREFIX);
            if (name.equals(removed)) {
                removed = StringUtils.removeStart((String)name, (String)LEGACY_CONSTANT_PREFIX);
            }
            return removed;
        }
        return name;
    }

    @Nullable
    public static String prependAnonymous(@Nullable String value) {
        if (value != null) {
            return ANONYMOUS_PREFIX + value;
        }
        return null;
    }

    public static boolean isAnonymous(@Nullable String name) {
        if (name != null) {
            return name.startsWith(ANONYMOUS_PREFIX) || name.startsWith(LEGACY_ANONYMOUS_PREFIX);
        }
        return false;
    }

    @Nullable
    public static String removeAnonymous(@Nullable String name) {
        String removed;
        if (VarNameUtils.isAnonymous(name) && name.equals(removed = StringUtils.removeStart((String)name, (String)ANONYMOUS_PREFIX))) {
            String string = StringUtils.removeStart((String)name, (String)LEGACY_ANONYMOUS_PREFIX);
        }
        return name;
    }

    public static String createUniqueConstVarName(Value value) {
        return TupleExprs.getConstVarName((Value)value);
    }

    public static String createUniqueConstVarNameLiteral(String label) {
        return VarNameUtils.createUniqueConstVarName((Value)VF.createLiteral(label));
    }

    public static String createUniqueConstVarNameIri(String iri) {
        return VarNameUtils.createUniqueConstVarName((Value)VF.createIRI(iri));
    }

    @Nullable
    public static String createSimpleConstVarName(@Nullable Var var) {
        String varName = null;
        if (var != null) {
            varName = var.getValue() != null && VarNameUtils.isConstant(var.getName()) ? VarNameUtils.prependConstant(var.getValue().stringValue()) : var.getName();
        }
        return varName;
    }

    public static Var createUniqueConstVar(Value value) {
        return new Var(TupleExprs.getConstVarName((Value)value), value);
    }
}

