/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.domain;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.persist.RdfDAOException;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class StatementMetadata {
    private static Gson gson = new GsonBuilder().enableComplexMapKeySerialization().registerTypeHierarchyAdapter(RyaType.class, (Object)new RyaTypeAdapter()).create();
    public static StatementMetadata EMPTY_METADATA = new StatementMetadata();
    private Map<RyaIRI, RyaType> metadataMap = new HashMap<RyaIRI, RyaType>();
    private Type type = new TypeToken<Map<RyaIRI, RyaType>>(){}.getType();

    public StatementMetadata() {
    }

    public StatementMetadata(byte[] value) throws RdfDAOException {
        try {
            if (value == null) {
                this.metadataMap = new HashMap<RyaIRI, RyaType>();
            } else {
                String metadataString = new String(value, "UTF8");
                this.metadataMap = (Map)gson.fromJson(metadataString, this.type);
                if (this.metadataMap == null) {
                    this.metadataMap = new HashMap<RyaIRI, RyaType>();
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RdfDAOException(e);
        }
    }

    public StatementMetadata(String statementMetadata) {
        try {
            this.metadataMap = (Map)gson.fromJson(statementMetadata, this.type);
        }
        catch (Exception e) {
            throw new RdfDAOException(e);
        }
    }

    public void addMetadata(RyaIRI key, RyaType value) {
        this.metadataMap.put(key, value);
    }

    public Map<RyaIRI, RyaType> getMetadata() {
        return this.metadataMap;
    }

    public String toString() {
        return gson.toJson(this.metadataMap, this.type);
    }

    public byte[] toBytes() {
        if (this.metadataMap.isEmpty()) {
            return null;
        }
        try {
            return this.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RyaTypeAdapter
    implements JsonSerializer<RyaType>,
    JsonDeserializer<RyaType> {
        public JsonElement serialize(RyaType src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.add("type", (JsonElement)new JsonPrimitive(src.getClass().getName()));
            StringBuilder builder = new StringBuilder();
            builder.append(src.getData()).append("\u0000").append(src.getDataType().toString());
            result.add("properties", (JsonElement)new JsonPrimitive(builder.toString()));
            return result;
        }

        public RyaType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String type = jsonObject.get("type").getAsString();
            JsonElement element = jsonObject.get("properties");
            String[] array = element.getAsJsonPrimitive().getAsString().split("\u0000");
            Preconditions.checkArgument((array.length == 2 ? 1 : 0) != 0);
            if (type.equals(RyaIRI.class.getName())) {
                return new RyaIRI(array[0]);
            }
            if (type.equals(RyaType.class.getName())) {
                RyaType ryaType = new RyaType(SimpleValueFactory.getInstance().createIRI(array[1]), array[0]);
                return ryaType;
            }
            throw new IllegalArgumentException("Unparseable RyaType.");
        }
    }
}

