/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import org.apache.rya.api.domain.RyaType;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public final class RyaTypeUtils {
    private static final ImmutableMap<Class<?>, RyaTypeMethod> METHOD_MAP = ImmutableMap.builder().put(Boolean.class, v -> RyaTypeUtils.booleanRyaType((Boolean)v)).put(Byte.class, v -> RyaTypeUtils.byteRyaType((Byte)v)).put(Date.class, v -> RyaTypeUtils.dateRyaType((Date)v)).put(DateTime.class, v -> RyaTypeUtils.dateRyaType((DateTime)v)).put(Double.class, v -> RyaTypeUtils.doubleRyaType((Double)v)).put(Float.class, v -> RyaTypeUtils.floatRyaType((Float)v)).put(Integer.class, v -> RyaTypeUtils.intRyaType((Integer)v)).put(Long.class, v -> RyaTypeUtils.longRyaType((Long)v)).put(Short.class, v -> RyaTypeUtils.shortRyaType((Short)v)).put(String.class, v -> RyaTypeUtils.stringRyaType((String)v)).put(IRI.class, v -> RyaTypeUtils.iriRyaType((IRI)v)).put(SimpleIRI.class, v -> RyaTypeUtils.iriRyaType((IRI)((SimpleIRI)v))).build();

    private RyaTypeUtils() {
    }

    public static RyaType booleanRyaType(Boolean value) {
        return new RyaType(XMLSchema.BOOLEAN, Boolean.toString(value));
    }

    public static RyaType byteRyaType(Byte value) {
        return new RyaType(XMLSchema.BYTE, Byte.toString(value));
    }

    public static RyaType dateRyaType(Date value) {
        DateTime dateTime = new DateTime(value.getTime());
        StringBuffer sb = new StringBuffer();
        ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).printTo(sb, dateTime.getMillis());
        String formattedDate = sb.toString();
        return new RyaType(XMLSchema.DATE, formattedDate);
    }

    public static RyaType dateRyaType(DateTime value) {
        StringBuffer sb = new StringBuffer();
        ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).printTo(sb, value.getMillis());
        String formattedDate = sb.toString();
        return new RyaType(XMLSchema.DATETIME, formattedDate);
    }

    public static RyaType doubleRyaType(Double value) {
        return new RyaType(XMLSchema.DOUBLE, Double.toString(value));
    }

    public static RyaType floatRyaType(Float value) {
        return new RyaType(XMLSchema.FLOAT, Float.toString(value.floatValue()));
    }

    public static RyaType intRyaType(Integer value) {
        return new RyaType(XMLSchema.INTEGER, Integer.toString(value));
    }

    public static RyaType longRyaType(Long value) {
        return new RyaType(XMLSchema.LONG, Long.toString(value));
    }

    public static RyaType shortRyaType(Short value) {
        return new RyaType(XMLSchema.SHORT, Short.toString(value));
    }

    public static RyaType stringRyaType(String value) {
        return new RyaType(XMLSchema.STRING, value);
    }

    public static RyaType iriRyaType(IRI value) {
        return new RyaType(XMLSchema.ANYURI, value.stringValue());
    }

    public static RyaType getRyaTypeForClass(Class<?> classType, Object value) {
        RyaTypeMethod method = (RyaTypeMethod)METHOD_MAP.get(classType);
        RyaType ryaType = null;
        if (method != null) {
            ryaType = method.callRyaTypeMethod(value);
        }
        return ryaType;
    }

    private static interface RyaTypeMethod {
        public RyaType callRyaTypeMethod(Object var1);
    }
}

