/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.domain;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.apache.rya.api.domain.RyaStatement;

public class RyaSubGraph {
    private String id;
    private Set<RyaStatement> statements;

    public RyaSubGraph(String id) {
        this.id = id;
        this.statements = new HashSet<RyaStatement>();
    }

    public RyaSubGraph(String id, Set<RyaStatement> statements) {
        this.id = id;
        this.statements = statements;
    }

    public String getId() {
        return this.id;
    }

    public Set<RyaStatement> getStatements() {
        return this.statements;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStatements(Set<RyaStatement> statements) {
        this.statements = statements;
    }

    public void addStatement(RyaStatement statement) {
        this.statements.add(statement);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RyaSubGraph) {
            RyaSubGraph bundle = (RyaSubGraph)other;
            return Objects.equal((Object)this.id, (Object)((RyaSubGraph)other).id) && Objects.equal(this.statements, bundle.statements);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.statements});
    }

    public String toString() {
        return "Rya Subgraph {\n" + ("   Rya Subgraph ID: " + this.id + "\n") + ("   Rya Statements: " + this.statements + "\n");
    }
}

