/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.domain;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.StatementMetadata;

public class RyaStatement {
    private RyaIRI subject;
    private RyaIRI predicate;
    private RyaType object;
    private RyaIRI context;
    private String qualifer;
    private byte[] columnVisibility;
    private byte[] value;
    private Long timestamp;

    public RyaStatement() {
    }

    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object) {
        this(subject, predicate, object, null);
    }

    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context) {
        this(subject, predicate, object, context, null);
    }

    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, String qualifier) {
        this(subject, predicate, object, context, qualifier, new StatementMetadata());
    }

    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, String qualifier, StatementMetadata metadata) {
        this(subject, predicate, object, context, qualifier, metadata, null);
    }

    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, String qualifier, StatementMetadata metadata, byte[] columnVisibility) {
        this(subject, predicate, object, context, qualifier, columnVisibility, metadata.toBytes());
    }

    @Deprecated
    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, String qualifier, byte[] columnVisibility, byte[] value) {
        this(subject, predicate, object, context, qualifier, columnVisibility, value, null);
    }

    @Deprecated
    public RyaStatement(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, String qualifier, byte[] columnVisibility, byte[] value, Long timestamp) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.context = context;
        this.qualifer = qualifier;
        this.columnVisibility = columnVisibility;
        this.value = value;
        this.timestamp = timestamp != null ? timestamp : System.currentTimeMillis();
    }

    public RyaIRI getSubject() {
        return this.subject;
    }

    public void setSubject(RyaIRI subject) {
        this.subject = subject;
    }

    public RyaIRI getPredicate() {
        return this.predicate;
    }

    public void setPredicate(RyaIRI predicate) {
        this.predicate = predicate;
    }

    public RyaType getObject() {
        return this.object;
    }

    public void setObject(RyaType object) {
        this.object = object;
    }

    public RyaIRI getContext() {
        return this.context;
    }

    public void setContext(RyaIRI context) {
        this.context = context;
    }

    public byte[] getColumnVisibility() {
        return this.columnVisibility;
    }

    public void setColumnVisibility(byte[] columnVisibility) {
        this.columnVisibility = columnVisibility;
    }

    public StatementMetadata getMetadata() {
        try {
            return new StatementMetadata(this.value);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setStatementMetadata(StatementMetadata metadata) {
        this.value = metadata.toBytes();
    }

    @Deprecated
    public byte[] getValue() {
        return this.value;
    }

    @Deprecated
    public void setValue(byte[] value) {
        this.value = value;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RyaStatement that = (RyaStatement)o;
        if (!Arrays.equals(this.columnVisibility, that.columnVisibility)) {
            return false;
        }
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        if (this.object != null ? !this.object.equals(that.object) : that.object != null) {
            return false;
        }
        if (this.predicate != null ? !this.predicate.equals(that.predicate) : that.predicate != null) {
            return false;
        }
        if (this.qualifer != null ? !this.qualifer.equals(that.qualifer) : that.qualifer != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.subject != null ? this.subject.hashCode() : 0;
        result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.qualifer != null ? this.qualifer.hashCode() : 0);
        result = 31 * result + (this.columnVisibility != null ? Arrays.hashCode(this.columnVisibility) : 0);
        result = 31 * result + (this.value != null ? Arrays.hashCode(this.value) : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String getQualifer() {
        return this.qualifer;
    }

    public void setQualifer(String qualifer) {
        this.qualifer = qualifer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RyaStatement");
        sb.append("{subject=").append(this.subject);
        sb.append(", predicate=").append(this.predicate);
        sb.append(", object=").append(this.object);
        sb.append(", context=").append(this.context);
        sb.append(", qualifier=").append(this.qualifer);
        sb.append(", columnVisibility=").append(this.columnVisibility == null ? "null" : new String(this.columnVisibility, StandardCharsets.UTF_8));
        sb.append(", value=").append(this.value == null ? "null" : new String(this.value, StandardCharsets.UTF_8));
        sb.append(", timestamp=").append(this.timestamp);
        sb.append('}');
        return sb.toString();
    }

    public static RyaStatementBuilder builder() {
        return new RyaStatementBuilder();
    }

    public static RyaStatementBuilder builder(RyaStatement ryaStatement) {
        return new RyaStatementBuilder(ryaStatement);
    }

    public static class RyaStatementBuilder {
        RyaStatement ryaStatement;

        public RyaStatementBuilder() {
            this.ryaStatement = new RyaStatement();
        }

        public RyaStatementBuilder(RyaStatement ryaStatement) {
            this.ryaStatement = ryaStatement;
        }

        public RyaStatementBuilder setTimestamp(Long timestamp) {
            this.ryaStatement.setTimestamp(timestamp);
            return this;
        }

        @Deprecated
        public RyaStatementBuilder setValue(byte[] value) {
            this.ryaStatement.setValue(value);
            return this;
        }

        public RyaStatementBuilder setMetadata(StatementMetadata metadata) {
            this.ryaStatement.setValue(metadata.toBytes());
            return this;
        }

        public RyaStatementBuilder setColumnVisibility(byte[] columnVisibility) {
            this.ryaStatement.setColumnVisibility(columnVisibility);
            return this;
        }

        public RyaStatementBuilder setQualifier(String str) {
            this.ryaStatement.setQualifer(str);
            return this;
        }

        public RyaStatementBuilder setContext(RyaIRI ryaIRI) {
            this.ryaStatement.setContext(ryaIRI);
            return this;
        }

        public RyaStatementBuilder setSubject(RyaIRI ryaIRI) {
            this.ryaStatement.setSubject(ryaIRI);
            return this;
        }

        public RyaStatementBuilder setPredicate(RyaIRI ryaIRI) {
            this.ryaStatement.setPredicate(ryaIRI);
            return this;
        }

        public RyaStatementBuilder setObject(RyaType ryaType) {
            this.ryaStatement.setObject(ryaType);
            return this;
        }

        public RyaStatement build() {
            return this.ryaStatement;
        }
    }
}

