/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.date;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.rya.api.date.TtlValueConverter;
import org.eclipse.rdf4j.model.Value;

public class DateTimeTtlValueConverter
implements TtlValueConverter {
    private Value start;
    private Value stop;
    private TimeZone timeZone = TimeZone.getTimeZone("Zulu");

    @Override
    public void convert(String ttl, String startTime) {
        try {
            long ttl_l = Long.parseLong(ttl);
            long stop_l = System.currentTimeMillis();
            if (startTime != null) {
                stop_l = Long.parseLong(startTime);
            }
            long start_l = stop_l - ttl_l;
            GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance();
            cal.setTimeZone(this.getTimeZone());
            cal.setTimeInMillis(start_l);
            DatatypeFactory factory = DatatypeFactory.newInstance();
            this.start = VF.createLiteral(factory.newXMLGregorianCalendar(cal));
            cal.setTimeInMillis(stop_l);
            this.stop = VF.createLiteral(factory.newXMLGregorianCalendar(cal));
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Exception occurred creating DataTypeFactory", e);
        }
    }

    @Override
    public Value getStart() {
        return this.start;
    }

    @Override
    public Value getStop() {
        return this.stop;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
}

