/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.apache.rya.api.client.RyaClientException;

@DefaultAnnotation(value={NonNull.class})
public interface Install {
    public void install(String var1, InstallConfiguration var2) throws DuplicateInstanceNameException, RyaClientException;

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static class InstallConfiguration {
        private final boolean enableTableHashPrefix;
        private final boolean enableFreeTextIndex;
        private final boolean enableGeoIndex;
        private final boolean enableEntityCentricIndex;
        private final boolean enableTemporalIndex;
        private final boolean enablePcjIndex;
        private final Optional<String> fluoPcjAppName;

        private InstallConfiguration(boolean enableTableHashPrefix, boolean enableFreeTextIndex, boolean enableGeoIndex, boolean enableEntityCentricIndex, boolean enableTemporalIndex, boolean enablePcjIndex, Optional<String> fluoPcjAppName) {
            this.enableTableHashPrefix = Objects.requireNonNull(enableTableHashPrefix);
            this.enableFreeTextIndex = Objects.requireNonNull(enableFreeTextIndex);
            this.enableGeoIndex = Objects.requireNonNull(enableGeoIndex);
            this.enableEntityCentricIndex = Objects.requireNonNull(enableEntityCentricIndex);
            this.enableTemporalIndex = Objects.requireNonNull(enableTemporalIndex);
            this.enablePcjIndex = Objects.requireNonNull(enablePcjIndex);
            this.fluoPcjAppName = Objects.requireNonNull(fluoPcjAppName);
        }

        public boolean isTableHashPrefixEnabled() {
            return this.enableTableHashPrefix;
        }

        public boolean isFreeTextIndexEnabled() {
            return this.enableFreeTextIndex;
        }

        public boolean isGeoIndexEnabled() {
            return this.enableGeoIndex;
        }

        public boolean isEntityCentrixIndexEnabled() {
            return this.enableEntityCentricIndex;
        }

        public boolean isTemporalIndexEnabled() {
            return this.enableTemporalIndex;
        }

        public boolean isPcjIndexEnabled() {
            return this.enablePcjIndex;
        }

        public Optional<String> getFluoPcjAppName() {
            return this.fluoPcjAppName;
        }

        public int hashCode() {
            return Objects.hash(this.enableTableHashPrefix, this.enableFreeTextIndex, this.enableGeoIndex, this.enableEntityCentricIndex, this.enableTemporalIndex, this.enablePcjIndex, this.fluoPcjAppName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InstallConfiguration) {
                InstallConfiguration config = (InstallConfiguration)obj;
                return this.enableTableHashPrefix == config.enableTableHashPrefix && this.enableFreeTextIndex == config.enableFreeTextIndex && this.enableGeoIndex == config.enableGeoIndex && this.enableEntityCentricIndex == config.enableEntityCentricIndex && this.enableTemporalIndex == config.enableTemporalIndex && this.enablePcjIndex == config.enablePcjIndex && Objects.equals(this.fluoPcjAppName, config.fluoPcjAppName);
            }
            return false;
        }

        public static Builder builder() {
            return new Builder();
        }

        @DefaultAnnotation(value={NonNull.class})
        public static class Builder {
            private boolean enableTableHashPrefix = false;
            private boolean enableFreeTextIndex = false;
            private boolean enableGeoIndex = false;
            private boolean enableEntityCentricIndex = false;
            private boolean enableTemporalIndex = false;
            private boolean enablePcjIndex = false;
            private String fluoPcjAppName = null;

            public Builder setEnableTableHashPrefix(boolean enabled) {
                this.enableTableHashPrefix = enabled;
                return this;
            }

            public Builder setEnableFreeTextIndex(boolean enabled) {
                this.enableFreeTextIndex = enabled;
                return this;
            }

            public Builder setEnableGeoIndex(boolean enabled) {
                this.enableGeoIndex = enabled;
                return this;
            }

            public Builder setEnableEntityCentricIndex(boolean enabled) {
                this.enableEntityCentricIndex = enabled;
                return this;
            }

            public Builder setEnableTemporalIndex(boolean enabled) {
                this.enableTemporalIndex = enabled;
                return this;
            }

            public Builder setEnablePcjIndex(boolean enabled) {
                this.enablePcjIndex = enabled;
                return this;
            }

            public Builder setFluoPcjAppName(@Nullable String fluoPcjAppName) {
                this.fluoPcjAppName = fluoPcjAppName;
                return this;
            }

            public InstallConfiguration build() {
                return new InstallConfiguration(this.enableTableHashPrefix, this.enableFreeTextIndex, this.enableGeoIndex, this.enableEntityCentricIndex, this.enableTemporalIndex, this.enablePcjIndex, Optional.fromNullable((Object)this.fluoPcjAppName));
            }
        }
    }

    public static class DuplicateInstanceNameException
    extends RyaClientException {
        private static final long serialVersionUID = 1L;

        public DuplicateInstanceNameException(String message) {
            super(message);
        }
    }
}

