/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.layout.TableLayoutStrategy;
import org.apache.rya.api.layout.TablePrefixLayoutStrategy;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RdfCloudTripleStoreUtils {
    public static final ValueFactory VF = SimpleValueFactory.getInstance();
    public static final Pattern literalPattern = Pattern.compile("^\"(.*?)\"((\\^\\^<(.+?)>)$|(@(.{2}))$)");

    public static IRI convertToUri(String namespace, String value) {
        IRI subjIri;
        if (value == null) {
            return null;
        }
        try {
            subjIri = VF.createIRI(value);
        }
        catch (Exception e) {
            if (namespace == null) {
                return null;
            }
            subjIri = VF.createIRI(namespace, value);
        }
        return subjIri;
    }

    public static Literal convertToDataTypeLiteral(String s) {
        int i = s.indexOf("^^");
        if (i != -1) {
            String val = s.substring(1, i - 1);
            int dt_i_start = i + 2;
            int dt_i_end = s.length();
            if (s.charAt(dt_i_start) == '<') {
                ++dt_i_start;
                --dt_i_end;
            }
            String dataType = s.substring(dt_i_start, dt_i_end);
            return VF.createLiteral(val, VF.createIRI(dataType));
        }
        return null;
    }

    public static boolean isDataTypeLiteral(String lit) {
        return lit != null && lit.indexOf("^^") != -1;
    }

    public static boolean isUri(String iri) {
        if (iri == null) {
            return false;
        }
        try {
            VF.createIRI(iri);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String layoutToTable(RdfCloudTripleStoreConstants.TABLE_LAYOUT layout, RdfCloudTripleStoreConfiguration conf) {
        TableLayoutStrategy tableLayoutStrategy = conf.getTableLayoutStrategy();
        return RdfCloudTripleStoreUtils.layoutToTable(layout, tableLayoutStrategy);
    }

    public static String layoutToTable(RdfCloudTripleStoreConstants.TABLE_LAYOUT layout, TableLayoutStrategy tableLayoutStrategy) {
        if (tableLayoutStrategy == null) {
            tableLayoutStrategy = new TablePrefixLayoutStrategy();
        }
        switch (layout) {
            case SPO: {
                return tableLayoutStrategy.getSpo();
            }
            case PO: {
                return tableLayoutStrategy.getPo();
            }
            case OSP: {
                return tableLayoutStrategy.getOsp();
            }
        }
        return null;
    }

    public static String layoutPrefixToTable(RdfCloudTripleStoreConstants.TABLE_LAYOUT layout, String prefix) {
        return RdfCloudTripleStoreUtils.layoutToTable(layout, new TablePrefixLayoutStrategy(prefix));
    }

    public static Value createValue(String resource) {
        if (RdfCloudTripleStoreUtils.isBNode(resource)) {
            return VF.createBNode(resource.substring(2));
        }
        Literal literal = RdfCloudTripleStoreUtils.makeLiteral(resource);
        if (literal != null) {
            return literal;
        }
        if (resource.contains(":") || resource.contains("/") || resource.contains("#")) {
            return VF.createIRI(resource);
        }
        throw new RuntimeException(resource + " is not a valid IRI, blank node, or literal value");
    }

    public static boolean isBNode(String resource) {
        return resource.length() > 2 && resource.startsWith("_:");
    }

    public static boolean isLiteral(String resource) {
        return literalPattern.matcher(resource).matches() || resource.startsWith("\"") && resource.endsWith("\"") && resource.length() > 1;
    }

    public static boolean isURI(String resource) {
        return !RdfCloudTripleStoreUtils.isBNode(resource) && !RdfCloudTripleStoreUtils.isLiteral(resource) && (resource.contains(":") || resource.contains("/") || resource.contains("#"));
    }

    public static Literal makeLiteral(String resource) {
        Matcher matcher = literalPattern.matcher(resource);
        if (matcher.matches()) {
            if (null != matcher.group(4)) {
                return VF.createLiteral(matcher.group(1), VF.createIRI(matcher.group(4)));
            }
            return VF.createLiteral(matcher.group(1), matcher.group(6));
        }
        if (resource.startsWith("\"") && resource.endsWith("\"") && resource.length() > 1) {
            return VF.createLiteral(resource.substring(1, resource.length() - 1));
        }
        return null;
    }

    public static class CustomEntry<T, U>
    implements Map.Entry<T, U> {
        private T key;
        private U value;

        public CustomEntry(T key, U value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public T getKey() {
            return this.key;
        }

        @Override
        public U getValue() {
            return this.value;
        }

        public T setKey(T key) {
            this.key = key;
            return this.key;
        }

        @Override
        public U setValue(U value) {
            this.value = value;
            return this.value;
        }

        public String toString() {
            return "CustomEntry{key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomEntry that = (CustomEntry)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

