/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.Text;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RdfCloudTripleStoreConstants {
    public static final String NAMESPACE = "urn:org.apache.rya/2012/05#";
    public static final String AUTH_NAMESPACE = "urn:org.apache.rya/auth/2012/05#";
    public static ValueFactory VALUE_FACTORY = SimpleValueFactory.getInstance();
    public static IRI RANGE = VALUE_FACTORY.createIRI("urn:org.apache.rya/2012/05#", "range");
    public static IRI PARTITION_TIMERANGE = VALUE_FACTORY.createIRI("urn:org.apache.mmrts.partition.rdf/08/2011#", "timeRange");
    public static Literal EMPTY_LITERAL = VALUE_FACTORY.createLiteral(0);
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final Text EMPTY_TEXT = new Text();
    public static final Long MAX_MEMORY = 10000000L;
    public static final Long MAX_TIME = 60000L;
    public static final Integer NUM_THREADS = 4;
    public static final String SUBJECT_CF = "s";
    public static final Text SUBJECT_CF_TXT = new Text("s");
    public static final String PRED_CF = "p";
    public static final Text PRED_CF_TXT = new Text("p");
    public static final String OBJ_CF = "o";
    public static final Text OBJ_CF_TXT = new Text("o");
    public static final String SUBJECTOBJECT_CF = "so";
    public static final Text SUBJECTOBJECT_CF_TXT = new Text("so");
    public static final String SUBJECTPRED_CF = "sp";
    public static final Text SUBJECTPRED_CF_TXT = new Text("sp");
    public static final String PREDOBJECT_CF = "po";
    public static final Text PREDOBJECT_CF_TXT = new Text("po");
    public static final String TBL_PRFX_DEF = "rya_";
    public static final String TBL_SPO_SUFFIX = "spo";
    public static final String TBL_PO_SUFFIX = "po";
    public static final String TBL_OSP_SUFFIX = "osp";
    public static final String TBL_EVAL_SUFFIX = "eval";
    public static final String TBL_STATS_SUFFIX = "prospects";
    public static final String TBL_SEL_SUFFIX = "selectivity";
    public static final String TBL_NS_SUFFIX = "ns";
    public static String TBL_SPO = "rya_spo";
    public static String TBL_PO = "rya_po";
    public static String TBL_OSP = "rya_osp";
    public static String TBL_EVAL = "rya_eval";
    public static String TBL_STATS = "rya_prospects";
    public static String TBL_SEL = "rya_selectivity";
    public static String TBL_NAMESPACE = "rya_ns";
    public static Text TBL_SPO_TXT = new Text(TBL_SPO);
    public static Text TBL_PO_TXT = new Text(TBL_PO);
    public static Text TBL_OSP_TXT = new Text(TBL_OSP);
    public static Text TBL_EVAL_TXT = new Text(TBL_EVAL);
    public static Text TBL_NAMESPACE_TXT = new Text(TBL_NAMESPACE);
    public static final String INFO_NAMESPACE = "namespace";
    public static final Text INFO_NAMESPACE_TXT = new Text("namespace");
    public static final byte DELIM_BYTE = 0;
    public static final byte TYPE_DELIM_BYTE = 1;
    public static final byte LAST_BYTE = -1;
    public static final byte[] LAST_BYTES = new byte[]{-1};
    public static final byte[] TYPE_DELIM_BYTES = new byte[]{1};
    public static final String DELIM = "\u0000";
    public static final String DELIM_STOP = "\u0001";
    public static final String LAST = "\uffdd";
    public static final String TYPE_DELIM = new String(TYPE_DELIM_BYTES, StandardCharsets.UTF_8);
    public static final byte[] DELIM_BYTES = "\u0000".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DELIM_STOP_BYTES = "\u0001".getBytes(StandardCharsets.UTF_8);
    public static final int URI_MARKER = 7;
    public static final int BNODE_MARKER = 8;
    public static final int PLAIN_LITERAL_MARKER = 9;
    public static final int LANG_LITERAL_MARKER = 10;
    public static final int DATATYPE_LITERAL_MARKER = 11;
    public static final int EOF_MARKER = 127;
    public static IRI RTS_SUBJECT = VALUE_FACTORY.createIRI("urn:org.apache.rya/2012/05#", "rts");
    public static RyaIRI RTS_SUBJECT_RYA = new RyaIRI(RTS_SUBJECT.stringValue());
    public static IRI RTS_VERSION_PREDICATE = VALUE_FACTORY.createIRI("urn:org.apache.rya/2012/05#", "version");
    public static RyaIRI RTS_VERSION_PREDICATE_RYA = new RyaIRI(RTS_VERSION_PREDICATE.stringValue());
    public static final Value VERSION = VALUE_FACTORY.createLiteral("3.0.0");
    public static RyaType VERSION_RYA = new RyaType(VERSION.stringValue());
    public static String RYA_CONFIG_AUTH = "RYACONFIG";

    public static void prefixTables(String prefix) {
        if (prefix == null) {
            prefix = TBL_PRFX_DEF;
        }
        TBL_SPO = prefix + TBL_SPO_SUFFIX;
        TBL_PO = prefix + "po";
        TBL_OSP = prefix + TBL_OSP_SUFFIX;
        TBL_EVAL = prefix + TBL_EVAL_SUFFIX;
        TBL_NAMESPACE = prefix + TBL_NS_SUFFIX;
        TBL_SPO_TXT = new Text(TBL_SPO);
        TBL_PO_TXT = new Text(TBL_PO);
        TBL_OSP_TXT = new Text(TBL_OSP);
        TBL_EVAL_TXT = new Text(TBL_EVAL);
        TBL_NAMESPACE_TXT = new Text(TBL_NAMESPACE);
    }

    public static enum TABLE_LAYOUT {
        SPO,
        PO,
        OSP;

    }
}

