/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api;

import org.apache.rya.api.RdfCloudTripleStoreConfiguration;

public abstract class RdfCloudTripleStoreConfigurationBuilder<B extends RdfCloudTripleStoreConfigurationBuilder<B, C>, C extends RdfCloudTripleStoreConfiguration> {
    private String prefix = "rya_";
    private String auths;
    private String visibilities;
    private boolean useInference = false;
    private boolean displayPlan = false;

    protected abstract B confBuilder();

    protected abstract C createConf();

    public B setUseInference(boolean useInference) {
        this.useInference = useInference;
        return this.confBuilder();
    }

    public B setAuths(String auths) {
        this.auths = auths;
        return this.confBuilder();
    }

    public B setVisibilities(String visibilities) {
        this.visibilities = visibilities;
        return this.confBuilder();
    }

    public B setRyaPrefix(String prefix) {
        this.prefix = prefix;
        return this.confBuilder();
    }

    public B setDisplayQueryPlan(boolean displayPlan) {
        this.displayPlan = displayPlan;
        return this.confBuilder();
    }

    public C build() {
        return this.getConf(this.createConf());
    }

    private C getConf(C conf) {
        ((RdfCloudTripleStoreConfiguration)((Object)conf)).setInfer(this.useInference);
        ((RdfCloudTripleStoreConfiguration)((Object)conf)).setTablePrefix(this.prefix);
        conf.setInt("sc.cloudbase.numPartitions", 3);
        ((RdfCloudTripleStoreConfiguration)((Object)conf)).setAuths(this.auths);
        if (this.visibilities != null) {
            ((RdfCloudTripleStoreConfiguration)((Object)conf)).setCv(this.visibilities);
        }
        ((RdfCloudTripleStoreConfiguration)((Object)conf)).setDisplayQueryPlan(this.displayPlan);
        return conf;
    }

    protected static boolean getBoolean(String boolString) {
        return Boolean.parseBoolean(boolString);
    }
}

