/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.layout.TableLayoutStrategy;
import org.apache.rya.api.layout.TablePrefixLayoutStrategy;
import org.apache.rya.api.persist.RdfEvalStatsDAO;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;

public abstract class RdfCloudTripleStoreConfiguration
extends Configuration {
    public static final String CONF_TTL = "query.ttl";
    public static final String CONF_STARTTIME = "query.startTime";
    public static final String CONF_NUM_THREADS = "query.numthreads";
    public static final String CONF_PERFORMANT = "query.performant";
    public static final String CONF_INFER = "query.infer";
    public static final String CONF_USE_STATS = "query.usestats";
    public static final String CONF_USE_COMPOSITE = "query.usecompositecard";
    public static final String CONF_USE_SELECTIVITY = "query.useselectivity";
    public static final String CONF_TBL_PREFIX = "query.tblprefix";
    public static final String CONF_BATCH_SIZE = "query.batchsize";
    public static final String CONF_OFFSET = "query.offset";
    public static final String CONF_LIMIT = "query.limit";
    public static final String CONF_QUERYPLAN_FLAG = "query.printqueryplan";
    public static final String CONF_QUERY_AUTH = "query.auth";
    public static final String CONF_RESULT_FORMAT = "query.resultformat";
    public static final String CONF_CV = "conf.cv";
    public static final String CONF_TBL_SPO = "tbl.spo";
    public static final String CONF_TBL_PO = "tbl.po";
    public static final String CONF_TBL_OSP = "tbl.osp";
    public static final String CONF_TBL_NS = "tbl.ns";
    public static final String CONF_TBL_EVAL = "tbl.eval";
    public static final String CONF_PREFIX_ROW_WITH_HASH = "tbl.hashprefix";
    public static final String CONF_OPTIMIZERS = "query.optimizers";
    public static final String CONF_PCJ_OPTIMIZER = "pcj.query.optimizer";
    public static final String CONF_PCJ_TABLES = "pcj.index.tables";
    public static final String CONF_STATEMENT_METADATA_PROPERTIES = "statement.metadata.properites";
    public static final String CONF_USE_STATEMENT_METADATA = "use.statement.metadata";
    public static final String STATS_PUSH_EMPTY_RDFTYPE_DOWN = "conf.stats.rdftype.down";
    public static final String INFER_INCLUDE_ALL_VALUES_FROM = "infer.include.allvaluesfrom";
    public static final String INFER_INCLUDE_DOMAIN_RANGE = "infer.include.domainrange";
    public static final String INFER_INCLUDE_HAS_SELF = "infer.include.hasself";
    public static final String INFER_INCLUDE_HAS_VALUE = "infer.include.hasvalue";
    public static final String INFER_INCLUDE_INTERSECTION_OF = "infer.include.intersectionof";
    public static final String INFER_INCLUDE_INVERSEOF = "infer.include.inverseof";
    public static final String INFER_INCLUDE_ONE_OF = "infer.include.oneof";
    public static final String INFER_INCLUDE_PROPERTY_CHAIN = "infer.include.propertychain";
    public static final String INFER_INCLUDE_REFLEXIVE_PROP = "infer.include.reflexiveprop";
    public static final String INFER_INCLUDE_SOME_VALUES_FROM = "infer.include.somevaluesfrom";
    public static final String INFER_INCLUDE_SAME_AS = "infer.include.sameas";
    public static final String INFER_INCLUDE_SUBCLASSOF = "infer.include.subclassof";
    public static final String INFER_INCLUDE_SUBPROPOF = "infer.include.subpropof";
    public static final String INFER_INCLUDE_SYMMPROP = "infer.include.symmprop";
    public static final String INFER_INCLUDE_TRANSITIVEPROP = "infer.include.transprop";
    public static final String RDF_DAO_CLASS = "class.rdf.dao";
    public static final String RDF_EVAL_STATS_DAO_CLASS = "class.rdf.evalstats";
    public static final String REGEX_SUBJECT = "query.regex.subject";
    public static final String REGEX_PREDICATE = "query.regex.predicate";
    public static final String REGEX_OBJECT = "query.regex.object";
    private static final String[] EMPTY_STR_ARR = new String[0];
    private TableLayoutStrategy tableLayoutStrategy = new TablePrefixLayoutStrategy();

    public RdfCloudTripleStoreConfiguration() {
    }

    public RdfCloudTripleStoreConfiguration(Configuration other) {
        super(other);
        if (other instanceof RdfCloudTripleStoreConfiguration) {
            this.setTableLayoutStrategy(((RdfCloudTripleStoreConfiguration)other).getTableLayoutStrategy());
        }
    }

    public abstract RdfCloudTripleStoreConfiguration clone();

    public TableLayoutStrategy getTableLayoutStrategy() {
        return this.tableLayoutStrategy;
    }

    public void setTableLayoutStrategy(TableLayoutStrategy tableLayoutStrategy) {
        this.tableLayoutStrategy = tableLayoutStrategy != null ? tableLayoutStrategy : new TablePrefixLayoutStrategy();
        this.set(CONF_TBL_SPO, this.tableLayoutStrategy.getSpo());
        this.set(CONF_TBL_PO, this.tableLayoutStrategy.getPo());
        this.set(CONF_TBL_OSP, this.tableLayoutStrategy.getOsp());
        this.set(CONF_TBL_NS, this.tableLayoutStrategy.getNs());
        this.set(CONF_TBL_EVAL, this.tableLayoutStrategy.getEval());
    }

    public Long getTtl() {
        String val = this.get(CONF_TTL);
        if (val != null) {
            return Long.valueOf(val);
        }
        return null;
    }

    public void setTtl(Long ttl) {
        Preconditions.checkNotNull((Object)ttl);
        Preconditions.checkArgument((ttl >= 0L ? 1 : 0) != 0, (Object)"ttl must be non negative");
        this.set(CONF_TTL, ttl.toString());
    }

    public Long getStartTime() {
        String val = this.get(CONF_STARTTIME);
        if (val != null) {
            return Long.valueOf(val);
        }
        return null;
    }

    public void setStartTime(Long startTime) {
        Preconditions.checkNotNull((Object)startTime);
        Preconditions.checkArgument((startTime >= 0L ? 1 : 0) != 0, (Object)"startTime must be non negative");
        this.set(CONF_STARTTIME, startTime.toString());
    }

    public Integer getNumThreads() {
        return this.getInt(CONF_NUM_THREADS, 2);
    }

    public void setNumThreads(Integer numThreads) {
        Preconditions.checkNotNull((Object)numThreads);
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (Object)"numThreads must be greater than 0");
        this.setInt(CONF_NUM_THREADS, numThreads);
    }

    public Boolean isPerformant() {
        return this.getBoolean(CONF_PERFORMANT, true);
    }

    public void setPerformant(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_PERFORMANT, val);
    }

    public Boolean isInfer() {
        return this.getBoolean(CONF_INFER, false);
    }

    public void setInfer(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_INFER, val);
    }

    public Boolean isUseStats() {
        return this.getBoolean(CONF_USE_STATS, false);
    }

    public void setUseStats(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_USE_STATS, val);
    }

    public Boolean isUseSelectivity() {
        return this.getBoolean(CONF_USE_SELECTIVITY, false);
    }

    public void setUseSelectivity(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_USE_SELECTIVITY, val);
    }

    public Boolean isPrefixRowsWithHash() {
        return this.getBoolean(CONF_PREFIX_ROW_WITH_HASH, false);
    }

    public void setPrefixRowsWithHash(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_PREFIX_ROW_WITH_HASH, val);
    }

    public String getTablePrefix() {
        return this.get(CONF_TBL_PREFIX, "rya_");
    }

    public void setTablePrefix(String tablePrefix) {
        Preconditions.checkNotNull((Object)tablePrefix);
        this.set(CONF_TBL_PREFIX, tablePrefix);
        this.setTableLayoutStrategy(new TablePrefixLayoutStrategy(tablePrefix));
    }

    public Integer getBatchSize() {
        String val = this.get(CONF_BATCH_SIZE);
        if (val != null) {
            return Integer.valueOf(val);
        }
        return null;
    }

    public void setBatchSize(Long batchSize) {
        Preconditions.checkNotNull((Object)batchSize);
        Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (Object)"Batch Size must be greater than 0");
        this.setLong(CONF_BATCH_SIZE, batchSize);
    }

    public Long getOffset() {
        String val = this.get(CONF_OFFSET);
        if (val != null) {
            return Long.valueOf(val);
        }
        return null;
    }

    public void setOffset(Long offset) {
        Preconditions.checkNotNull((Object)offset);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be positive");
        this.setLong(CONF_OFFSET, offset);
    }

    public Long getLimit() {
        String val = this.get(CONF_LIMIT);
        if (val != null) {
            return Long.valueOf(val);
        }
        return null;
    }

    public void setLimit(Long limit) {
        Preconditions.checkNotNull((Object)limit);
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be positive");
        this.setLong(CONF_LIMIT, limit);
    }

    public Boolean isDisplayQueryPlan() {
        return this.getBoolean(CONF_QUERYPLAN_FLAG, false);
    }

    public void setDisplayQueryPlan(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_QUERYPLAN_FLAG, val);
    }

    @Deprecated
    public String getAuth() {
        return Joiner.on((String)",").join((Object[])this.getAuths());
    }

    @Deprecated
    public void setAuth(String auth) {
        Preconditions.checkNotNull((Object)auth);
        this.setStrings(CONF_QUERY_AUTH, new String[]{auth});
    }

    public String[] getAuths() {
        return this.getStrings(CONF_QUERY_AUTH, EMPTY_STR_ARR);
    }

    public void setAuths(String ... auths) {
        Preconditions.checkNotNull((Object)auths);
        this.setStrings(CONF_QUERY_AUTH, auths);
    }

    public String getEmit() {
        return this.get(CONF_RESULT_FORMAT);
    }

    public void setEmit(String emit) {
        Preconditions.checkNotNull((Object)emit);
        this.set(CONF_RESULT_FORMAT, emit);
    }

    public String getCv() {
        return this.get(CONF_CV);
    }

    public void setCv(String cv) {
        Preconditions.checkNotNull((Object)cv);
        this.set(CONF_CV, cv);
    }

    public Boolean isUseCompositeCardinality() {
        return this.getBoolean(CONF_USE_COMPOSITE, true);
    }

    public void setCompositeCardinality(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(CONF_USE_COMPOSITE, val);
    }

    public Boolean isStatsPushEmptyRdftypeDown() {
        return this.getBoolean(STATS_PUSH_EMPTY_RDFTYPE_DOWN, true);
    }

    public void setStatsPushEmptyRdftypeDown(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(STATS_PUSH_EMPTY_RDFTYPE_DOWN, val);
    }

    public Boolean isInferAllValuesFrom() {
        return this.getBoolean(INFER_INCLUDE_ALL_VALUES_FROM, true);
    }

    public void setInferAllValuesFrom(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_ALL_VALUES_FROM, value);
    }

    public Boolean isInferDomainRange() {
        return this.getBoolean(INFER_INCLUDE_DOMAIN_RANGE, true);
    }

    public void setInferDomainRange(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_DOMAIN_RANGE, val);
    }

    public Boolean isInferHasSelf() {
        return this.getBoolean(INFER_INCLUDE_HAS_SELF, true);
    }

    public void setInferHasSelf(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_HAS_SELF, val);
    }

    public Boolean isInferHasValue() {
        return this.getBoolean(INFER_INCLUDE_HAS_VALUE, true);
    }

    public void setInferHasValue(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_HAS_VALUE, value);
    }

    public Boolean isInferIntersectionOf() {
        return this.getBoolean(INFER_INCLUDE_INTERSECTION_OF, true);
    }

    public void setInferIntersectionOf(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_INTERSECTION_OF, value);
    }

    public Boolean isInferInverseOf() {
        return this.getBoolean(INFER_INCLUDE_INVERSEOF, true);
    }

    public void setInferInverseOf(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_INVERSEOF, val);
    }

    public Boolean isInferOneOf() {
        return this.getBoolean(INFER_INCLUDE_ONE_OF, true);
    }

    public void setInferOneOf(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_ONE_OF, value);
    }

    public Boolean isInferPropertyChain() {
        return this.getBoolean(INFER_INCLUDE_PROPERTY_CHAIN, true);
    }

    public void setInferPropertyChain(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_PROPERTY_CHAIN, value);
    }

    public Boolean isInferReflexiveProperty() {
        return this.getBoolean(INFER_INCLUDE_REFLEXIVE_PROP, true);
    }

    public void setInferReflexiveProperty(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_REFLEXIVE_PROP, value);
    }

    public Boolean isInferSameAs() {
        return this.getBoolean(INFER_INCLUDE_SAME_AS, true);
    }

    public void setInferSameAs(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_SAME_AS, value);
    }

    public Boolean isInferSomeValuesFrom() {
        return this.getBoolean(INFER_INCLUDE_SOME_VALUES_FROM, true);
    }

    public void setInferSomeValuesFrom(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.setBoolean(INFER_INCLUDE_SOME_VALUES_FROM, value);
    }

    public Boolean isInferSubClassOf() {
        return this.getBoolean(INFER_INCLUDE_SUBCLASSOF, true);
    }

    public void setInferSubClassOf(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_SUBCLASSOF, val);
    }

    public Boolean isInferSubPropertyOf() {
        return this.getBoolean(INFER_INCLUDE_SUBPROPOF, true);
    }

    public void setInferSubPropertyOf(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_SUBPROPOF, val);
    }

    public Boolean isInferSymmetricProperty() {
        return this.getBoolean(INFER_INCLUDE_SYMMPROP, true);
    }

    public void setInferSymmetricProperty(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_SYMMPROP, val);
    }

    public Boolean isInferTransitiveProperty() {
        return this.getBoolean(INFER_INCLUDE_TRANSITIVEPROP, true);
    }

    public void setInferTransitiveProperty(Boolean val) {
        Preconditions.checkNotNull((Object)val);
        this.setBoolean(INFER_INCLUDE_TRANSITIVEPROP, val);
    }

    public void setRdfEvalStatsDaoClass(Class<? extends RdfEvalStatsDAO> rdfEvalStatsDaoClass) {
        Preconditions.checkNotNull(rdfEvalStatsDaoClass);
        this.setClass(RDF_EVAL_STATS_DAO_CLASS, rdfEvalStatsDaoClass, RdfEvalStatsDAO.class);
    }

    public Class<? extends RdfEvalStatsDAO> getRdfEvalStatsDaoClass() {
        return this.getClass(RDF_EVAL_STATS_DAO_CLASS, null, RdfEvalStatsDAO.class);
    }

    public void setPcjTables(List<String> indexTables) {
        Preconditions.checkNotNull(indexTables);
        this.setStrings(CONF_PCJ_TABLES, indexTables.toArray(new String[0]));
    }

    public List<String> getPcjTables() {
        ArrayList pcjTables = Lists.newArrayList();
        String[] tables = this.getStrings(CONF_PCJ_TABLES);
        if (tables == null) {
            return pcjTables;
        }
        for (String table : tables) {
            Preconditions.checkNotNull((Object)table);
            pcjTables.add(table);
        }
        return pcjTables;
    }

    public void setUseStatementMetadata(boolean useMetadata) {
        this.setBoolean(CONF_USE_STATEMENT_METADATA, useMetadata);
    }

    public boolean getUseStatementMetadata() {
        return this.getBoolean(CONF_USE_STATEMENT_METADATA, false);
    }

    public void setStatementMetadataProperties(Set<RyaIRI> metadataProperties) {
        String[] propArray = new String[metadataProperties.size()];
        int i = 0;
        for (RyaIRI uri : metadataProperties) {
            propArray[i] = uri.getData();
            ++i;
        }
        this.setStrings(CONF_STATEMENT_METADATA_PROPERTIES, propArray);
    }

    public Set<RyaIRI> getStatementMetadataProperties() {
        HashSet<RyaIRI> uriSet = new HashSet<RyaIRI>();
        String[] uriStrings = this.getStrings(CONF_STATEMENT_METADATA_PROPERTIES);
        if (uriStrings != null) {
            for (String s : uriStrings) {
                uriSet.add(new RyaIRI(s));
            }
        }
        return uriSet;
    }

    public void setPcjOptimizer(Class<? extends QueryOptimizer> optimizer) {
        Preconditions.checkNotNull(optimizer);
        this.setClass(CONF_PCJ_OPTIMIZER, optimizer, QueryOptimizer.class);
    }

    public Class<QueryOptimizer> getPcjOptimizer() {
        Class opt = this.getClass(CONF_PCJ_OPTIMIZER, null, QueryOptimizer.class);
        if (opt != null) {
            Preconditions.checkArgument((boolean)QueryOptimizer.class.isAssignableFrom(opt));
            return opt;
        }
        return null;
    }

    public void setOptimizers(List<Class<? extends QueryOptimizer>> optimizers) {
        Preconditions.checkNotNull(optimizers);
        ArrayList strs = Lists.newArrayList();
        for (Class<? extends QueryOptimizer> ai : optimizers) {
            Preconditions.checkNotNull(ai);
            strs.add(ai.getName());
        }
        this.setStrings(CONF_OPTIMIZERS, strs.toArray(new String[0]));
    }

    public List<Class<QueryOptimizer>> getOptimizers() {
        ArrayList opts = Lists.newArrayList();
        for (Class clazz : this.getClasses(CONF_OPTIMIZERS, new Class[0])) {
            Preconditions.checkArgument((boolean)QueryOptimizer.class.isAssignableFrom(clazz));
            opts.add(clazz);
        }
        return opts;
    }

    public String getRegexSubject() {
        return this.get(REGEX_SUBJECT);
    }

    public void setRegexSubject(String regexSubject) {
        Preconditions.checkNotNull((Object)regexSubject);
        this.set(REGEX_SUBJECT, regexSubject);
    }

    public String getRegexPredicate() {
        return this.get(REGEX_PREDICATE);
    }

    public void setRegexPredicate(String regex) {
        Preconditions.checkNotNull((Object)regex);
        this.set(REGEX_PREDICATE, regex);
    }

    public String getRegexObject() {
        return this.get(REGEX_OBJECT);
    }

    public void setRegexObject(String regex) {
        Preconditions.checkNotNull((Object)regex);
        this.set(REGEX_OBJECT, regex);
    }
}

