/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.model.visibility;

import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.model.visibility.ColumnVisibility;

@DefaultAnnotation(value={NonNull.class})
public class VisibilitySimplifier {
    public static String unionAndSimplify(String vis1, String vis2) {
        Objects.requireNonNull(vis1);
        Objects.requireNonNull(vis2);
        if (vis1.isEmpty()) {
            return vis2;
        }
        if (vis2.isEmpty()) {
            return vis1;
        }
        return VisibilitySimplifier.simplify("(" + vis1 + ")&(" + vis2 + ")");
    }

    public static String simplify(String visibility) {
        Objects.requireNonNull(visibility);
        String last = visibility;
        String simplified = new String(new ColumnVisibility(visibility).flatten(), Charsets.UTF_8);
        while (!simplified.equals(last)) {
            last = simplified;
            simplified = new String(new ColumnVisibility(simplified).flatten(), Charsets.UTF_8);
        }
        return simplified;
    }
}

