/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.projection;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.rya.api.function.projection.BNodeIdFactory;
import org.apache.rya.api.function.projection.ProjectionEvaluator;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

@DefaultAnnotation(value={NonNull.class})
public class MultiProjectionEvaluator {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final Set<ProjectionEvaluator> projections;
    private final Set<String> blankNodeSourceNames;
    private final BNodeIdFactory bNodeIdFactory;

    public MultiProjectionEvaluator(Set<ProjectionEvaluator> projections, Set<String> blankNodeSourceNames, BNodeIdFactory bnodeIdFactory) {
        this.projections = Objects.requireNonNull(projections);
        this.blankNodeSourceNames = Objects.requireNonNull(blankNodeSourceNames);
        this.bNodeIdFactory = Objects.requireNonNull(bnodeIdFactory);
    }

    public static MultiProjectionEvaluator make(MultiProjection multiProjection, BNodeIdFactory bNodeIdFactory) {
        Objects.requireNonNull(multiProjection);
        TupleExpr arg = multiProjection.getArg();
        Optional<Extension> extension = arg instanceof Extension ? Optional.of((Extension)arg) : Optional.empty();
        HashSet<String> blankNodeSourceNames = new HashSet<String>();
        if (extension.isPresent()) {
            for (ExtensionElem elem : ((Extension)extension.get()).getElements()) {
                if (!(elem.getExpr() instanceof BNodeGenerator)) continue;
                blankNodeSourceNames.add(elem.getName());
            }
        }
        HashSet<ProjectionEvaluator> projections = new HashSet<ProjectionEvaluator>();
        for (ProjectionElemList projectionElemList : multiProjection.getProjections()) {
            projections.add(new ProjectionEvaluator(projectionElemList, extension));
        }
        return new MultiProjectionEvaluator(projections, blankNodeSourceNames, bNodeIdFactory);
    }

    public Set<VisibilityBindingSet> project(VisibilityBindingSet bs) {
        Objects.requireNonNull(bs);
        HashMap<String, BNode> blankNodes = new HashMap<String, BNode>();
        for (String blankNodeSourceName : this.blankNodeSourceNames) {
            blankNodes.put(blankNodeSourceName, VF.createBNode(this.bNodeIdFactory.nextId()));
        }
        HashSet<VisibilityBindingSet> results = new HashSet<VisibilityBindingSet>();
        for (ProjectionEvaluator projection : this.projections) {
            results.add(projection.project(bs, blankNodes));
        }
        return results;
    }
}

