/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.filter;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class FilterEvaluator {
    private static final Logger log = LoggerFactory.getLogger(FilterEvaluator.class);
    private static final StrictEvaluationStrategy EVALUATOR = new StrictEvaluationStrategy(new TripleSource(){
        private final ValueFactory valueFactory = SimpleValueFactory.getInstance();

        public ValueFactory getValueFactory() {
            return this.valueFactory;
        }

        public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource arg0, IRI arg1, Value arg2, Resource ... arg3) throws QueryEvaluationException {
            throw new UnsupportedOperationException();
        }
    }, null);
    private final ValueExpr condition;

    public FilterEvaluator(ValueExpr condition) {
        this.condition = Objects.requireNonNull(condition);
    }

    public static FilterEvaluator make(Filter filter) {
        Objects.requireNonNull(filter);
        ValueExpr condition = filter.getCondition();
        return new FilterEvaluator(condition);
    }

    public boolean filter(VisibilityBindingSet bs) {
        Objects.requireNonNull(bs);
        try {
            Value result = EVALUATOR.evaluate(this.condition, (BindingSet)bs);
            return QueryEvaluationUtil.getEffectiveBooleanValue((Value)result);
        }
        catch (QueryEvaluationException e) {
            log.error("Could not evaluate a Filter.", (Throwable)e);
            return false;
        }
    }
}

