/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

@DefaultAnnotation(value={NonNull.class})
public class AverageState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BigDecimal sum;
    private final BigInteger count;

    public AverageState() {
        this.sum = BigDecimal.ZERO;
        this.count = BigInteger.ZERO;
    }

    public AverageState(BigDecimal sum, BigInteger count) {
        this.sum = Objects.requireNonNull(sum);
        this.count = Objects.requireNonNull(count);
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public BigInteger getCount() {
        return this.count;
    }

    public int hashCode() {
        return Objects.hash(this.sum, this.count);
    }

    public boolean equals(Object o) {
        if (o instanceof AverageState) {
            AverageState state = (AverageState)o;
            return Objects.equals(this.sum, state.sum) && Objects.equals(this.count, state.count);
        }
        return false;
    }

    public String toString() {
        return "Sum: " + this.sum + " Count: " + this.count;
    }
}

