/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.apache.rya.api.function.aggregation.AggregationElement;
import org.apache.rya.api.function.aggregation.AggregationFunction;
import org.apache.rya.api.function.aggregation.AggregationState;
import org.apache.rya.api.function.aggregation.AggregationType;
import org.apache.rya.api.function.aggregation.AverageState;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public final class AverageFunction
implements AggregationFunction {
    private static final Logger log = LoggerFactory.getLogger(AverageFunction.class);
    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    @Override
    public void update(AggregationElement aggregation, AggregationState state, VisibilityBindingSet childBindingSet) {
        Preconditions.checkArgument((aggregation.getAggregationType() == AggregationType.AVERAGE ? 1 : 0) != 0, (Object)"The AverageFunction only accepts AVERAGE AggregationElements.");
        Objects.requireNonNull(state);
        Objects.requireNonNull(childBindingSet);
        String aggregatedName = aggregation.getAggregatedBindingName();
        if (childBindingSet.hasBinding(aggregatedName)) {
            Literal childLiteral;
            String resultName;
            MapBindingSet result = state.getBindingSet();
            boolean newBinding = !result.hasBinding(resultName = aggregation.getResultBindingName());
            Map<String, AverageState> averageStates = state.getAverageStates();
            AverageState averageState = newBinding ? new AverageState() : averageStates.get(resultName);
            Value childValue = childBindingSet.getValue(aggregatedName);
            if (childValue instanceof Literal && (childLiteral = (Literal)childValue).getDatatype() != null && XMLDatatypeUtil.isNumericDatatype((IRI)childLiteral.getDatatype())) {
                try {
                    Literal oldSum = VF.createLiteral(averageState.getSum());
                    BigDecimal sum = MathUtil.compute((Literal)oldSum, (Literal)childLiteral, (MathExpr.MathOp)MathExpr.MathOp.PLUS).decimalValue();
                    BigInteger count = averageState.getCount().add(BigInteger.ONE);
                    Literal sumLiteral = VF.createLiteral(sum);
                    Literal countLiteral = VF.createLiteral(count);
                    Literal average = MathUtil.compute((Literal)sumLiteral, (Literal)countLiteral, (MathExpr.MathOp)MathExpr.MathOp.DIVIDE);
                    result.addBinding(resultName, (Value)average);
                    averageState = new AverageState(sum, count);
                    averageStates.put(resultName, averageState);
                }
                catch (ValueExprEvaluationException e) {
                    log.error("A problem was encountered while updating an Average Aggregation. This binding set will be ignored: " + childBindingSet);
                    return;
                }
            }
        }
    }
}

