/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.iter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.log4j.Logger;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.mongodb.dao.MongoDBStorageStrategy;
import org.apache.rya.mongodb.document.operators.aggregation.AggregationUtil;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;

public class RyaStatementBindingSetCursorIterator
implements CloseableIteration<Map.Entry<RyaStatement, BindingSet>, RyaDAOException> {
    private static final Logger log = Logger.getLogger(RyaStatementBindingSetCursorIterator.class);
    private static final int QUERY_BATCH_SIZE = 50;
    private final MongoCollection<Document> coll;
    private final Multimap<RyaStatement, BindingSet> rangeMap;
    private final Multimap<RyaStatement, BindingSet> executedRangeMap = HashMultimap.create();
    private final Iterator<RyaStatement> queryIterator;
    private Iterator<Document> batchQueryResultsIterator;
    private RyaStatement currentResultStatement;
    private Iterator<BindingSet> currentBindingSetIterator;
    private final MongoDBStorageStrategy<RyaStatement> strategy;
    private final Authorizations auths;

    public RyaStatementBindingSetCursorIterator(MongoCollection<Document> coll, Multimap<RyaStatement, BindingSet> rangeMap, MongoDBStorageStrategy<RyaStatement> strategy, Authorizations auths) {
        this.coll = coll;
        this.rangeMap = rangeMap;
        this.queryIterator = rangeMap.keySet().iterator();
        this.strategy = strategy;
        this.auths = auths;
    }

    public boolean hasNext() {
        if (!this.currentBindingSetIteratorIsValid()) {
            this.findNextResult();
        }
        return this.currentBindingSetIteratorIsValid();
    }

    public Map.Entry<RyaStatement, BindingSet> next() {
        if (!this.currentBindingSetIteratorIsValid()) {
            this.findNextResult();
        }
        if (this.currentBindingSetIteratorIsValid()) {
            BindingSet currentBindingSet = this.currentBindingSetIterator.next();
            return new RdfCloudTripleStoreUtils.CustomEntry((Object)this.currentResultStatement, (Object)currentBindingSet);
        }
        return null;
    }

    private boolean currentBindingSetIteratorIsValid() {
        return this.currentBindingSetIterator != null && this.currentBindingSetIterator.hasNext();
    }

    private void findNextResult() {
        if (!this.currentBatchQueryResultCursorIsValid()) {
            this.submitBatchQuery();
        }
        if (this.currentBatchQueryResultCursorIsValid()) {
            Document queryResult = this.batchQueryResultsIterator.next();
            this.currentResultStatement = this.strategy.deserializeDocument(queryResult);
            HashSet bsList = new HashSet();
            for (RyaStatement executedQuery : this.executedRangeMap.keys()) {
                if (!RyaStatementBindingSetCursorIterator.isResultForQuery(executedQuery, this.currentResultStatement)) continue;
                bsList.addAll(this.executedRangeMap.get((Object)executedQuery));
            }
            this.currentBindingSetIterator = bsList.iterator();
        }
        if (!(this.currentBindingSetIterator != null && this.currentBindingSetIterator.hasNext() || !this.currentBatchQueryResultCursorIsValid() && !this.queryIterator.hasNext())) {
            this.findNextResult();
        }
    }

    private static boolean isResultForQuery(RyaStatement query, RyaStatement result) {
        return RyaStatementBindingSetCursorIterator.isResult((RyaType)query.getSubject(), (RyaType)result.getSubject()) && RyaStatementBindingSetCursorIterator.isResult((RyaType)query.getPredicate(), (RyaType)result.getPredicate()) && RyaStatementBindingSetCursorIterator.isResult(query.getObject(), result.getObject()) && RyaStatementBindingSetCursorIterator.isResult((RyaType)query.getContext(), (RyaType)result.getContext());
    }

    private static boolean isResult(RyaType query, RyaType result) {
        return query == null || query.equals((Object)result);
    }

    private void submitBatchQuery() {
        this.executedRangeMap.clear();
        ArrayList<Object> pipeline = new ArrayList<Object>();
        ArrayList<Document> matches = new ArrayList<Document>();
        for (int count = 0; this.queryIterator.hasNext() && count < 50; ++count) {
            RyaStatement query = this.queryIterator.next();
            this.executedRangeMap.putAll((Object)query, (Iterable)this.rangeMap.get((Object)query));
            Document currentQuery = this.strategy.getQuery(query);
            matches.add(currentQuery);
        }
        int numMatches = matches.size();
        if (numMatches > 1) {
            pipeline.add(Aggregates.match((Bson)Filters.or(matches)));
        } else if (numMatches == 1) {
            pipeline.add(Aggregates.match((Bson)((Bson)matches.get(0))));
        } else {
            this.batchQueryResultsIterator = Iterators.emptyIterator();
            return;
        }
        pipeline.addAll(AggregationUtil.createRedactPipeline(this.auths));
        log.trace(pipeline);
        AggregateIterable aggIter = this.coll.aggregate(pipeline);
        aggIter.batchSize(1000);
        this.batchQueryResultsIterator = aggIter.iterator();
    }

    private boolean currentBatchQueryResultCursorIsValid() {
        return this.batchQueryResultsIterator != null && this.batchQueryResultsIterator.hasNext();
    }

    public void close() throws RyaDAOException {
    }

    public void remove() throws RyaDAOException {
        this.next();
    }
}

