/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.instance;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.mongodb.instance.MongoDetailsAdapter;
import org.bson.Document;
import org.bson.conversions.Bson;

@DefaultAnnotation(value={NonNull.class})
public class MongoRyaInstanceDetailsRepository
implements RyaDetailsRepository {
    public static final String INSTANCE_DETAILS_COLLECTION_NAME = "instance_details";
    private final MongoDatabase db;
    private final String instanceName;

    public MongoRyaInstanceDetailsRepository(MongoClient client, String instanceName) {
        Preconditions.checkNotNull((Object)client);
        this.instanceName = Objects.requireNonNull(instanceName);
        this.db = client.getDatabase(this.instanceName);
    }

    public boolean isInitialized() throws RyaDetailsRepository.RyaDetailsRepositoryException {
        MongoCollection col = this.db.getCollection(INSTANCE_DETAILS_COLLECTION_NAME);
        return col.countDocuments() == 1L;
    }

    public void initialize(RyaDetails details) throws RyaDetailsRepository.AlreadyInitializedException, RyaDetailsRepository.RyaDetailsRepositoryException {
        Objects.requireNonNull(details);
        if (!details.getRyaInstanceName().equals(this.instanceName)) {
            throw new RyaDetailsRepository.RyaDetailsRepositoryException("The instance name that was in the provided 'details' does not match the instance name that this repository is connected to. Make sure you're connected to thecorrect Rya instance.");
        }
        if (this.isInitialized()) {
            throw new RyaDetailsRepository.AlreadyInitializedException("The repository has already been initialized for the Rya instance named '" + this.instanceName + "'.");
        }
        this.db.createCollection(INSTANCE_DETAILS_COLLECTION_NAME, new CreateCollectionOptions());
        MongoCollection col = this.db.getCollection(INSTANCE_DETAILS_COLLECTION_NAME);
        col.insertOne((Object)MongoDetailsAdapter.toDocument(details), new InsertOneOptions());
    }

    public RyaDetails getRyaInstanceDetails() throws RyaDetailsRepository.NotInitializedException, RyaDetailsRepository.RyaDetailsRepositoryException {
        if (!this.isInitialized()) {
            throw new RyaDetailsRepository.NotInitializedException("Could not fetch the details for the Rya instanced named '" + this.instanceName + "' because it has not been initialized yet.");
        }
        MongoCollection col = this.db.getCollection(INSTANCE_DETAILS_COLLECTION_NAME);
        Document mongoObj = (Document)col.find().first();
        try {
            return MongoDetailsAdapter.toRyaDetails(mongoObj);
        }
        catch (MongoDetailsAdapter.MalformedRyaDetailsException e) {
            throw new RyaDetailsRepository.RyaDetailsRepositoryException("The existing details details are malformed.", (Throwable)e);
        }
    }

    public void update(RyaDetails oldDetails, RyaDetails newDetails) throws RyaDetailsRepository.NotInitializedException, RyaDetailsRepository.ConcurrentUpdateException, RyaDetailsRepository.RyaDetailsRepositoryException {
        Document newObj;
        Document oldObj;
        Objects.requireNonNull(oldDetails);
        Objects.requireNonNull(newDetails);
        if (!newDetails.getRyaInstanceName().equals(this.instanceName)) {
            throw new RyaDetailsRepository.RyaDetailsRepositoryException("The instance name that was in the provided 'newDetails' does not match the instance name that this repository is connected to. Make sure you're connected to thecorrect Rya instance.");
        }
        if (!this.isInitialized()) {
            throw new RyaDetailsRepository.NotInitializedException("Could not update the details for the Rya instanced named '" + this.instanceName + "' because it has not been initialized yet.");
        }
        if (oldDetails.equals((Object)newDetails)) {
            return;
        }
        MongoCollection col = this.db.getCollection(INSTANCE_DETAILS_COLLECTION_NAME);
        UpdateResult result = col.replaceOne((Bson)(oldObj = MongoDetailsAdapter.toDocument(oldDetails)), (Object)(newObj = MongoDetailsAdapter.toDocument(newDetails)), new ReplaceOptions());
        if (result.getModifiedCount() != 1L) {
            throw new RyaDetailsRepository.ConcurrentUpdateException("Could not update the details for the Rya instance named '" + this.instanceName + "' because the old value is out of date.");
        }
    }
}

