/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.instance;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.rya.api.instance.RyaDetails;
import org.bson.Document;

@DefaultAnnotation(value={NonNull.class})
public class MongoDetailsAdapter {
    public static final String INSTANCE_KEY = "instanceName";
    public static final String VERSION_KEY = "version";
    public static final String ENTITY_DETAILS_KEY = "entityCentricDetails";
    public static final String GEO_DETAILS_KEY = "geoDetails";
    public static final String PCJ_DETAILS_KEY = "pcjDetails";
    public static final String PCJ_ENABLED_KEY = "enabled";
    public static final String PCJ_FLUO_KEY = "fluoName";
    public static final String PCJ_PCJS_KEY = "pcjs";
    public static final String PCJ_ID_KEY = "id";
    public static final String PCJ_UPDATE_STRAT_KEY = "updateStrategy";
    public static final String PCJ_LAST_UPDATE_KEY = "lastUpdate";
    public static final String TEMPORAL_DETAILS_KEY = "temporalDetails";
    public static final String FREETEXT_DETAILS_KEY = "freeTextDetails";
    public static final String PROSPECTOR_DETAILS_KEY = "prospectorDetails";
    public static final String JOIN_SELECTIVITY_DETAILS_KEY = "joinSelectivitiyDetails";
    public static final String RYA_STREAMS_DETAILS_KEY = "ryaStreamsDetails";
    public static final String RYA_STREAMS_HOSTNAME_KEY = "hostname";
    public static final String RYA_STREAMS_PORT_KEY = "port";

    public static Document toDocument(RyaDetails details) {
        Objects.requireNonNull(details);
        Document doc = new Document().append(INSTANCE_KEY, (Object)details.getRyaInstanceName()).append(VERSION_KEY, (Object)details.getRyaVersion()).append(ENTITY_DETAILS_KEY, (Object)details.getEntityCentricIndexDetails().isEnabled()).append(PCJ_DETAILS_KEY, (Object)MongoDetailsAdapter.toDocument(details.getPCJIndexDetails())).append(TEMPORAL_DETAILS_KEY, (Object)details.getTemporalIndexDetails().isEnabled()).append(FREETEXT_DETAILS_KEY, (Object)details.getFreeTextIndexDetails().isEnabled());
        if (details.getProspectorDetails().getLastUpdated().isPresent()) {
            doc.append(PROSPECTOR_DETAILS_KEY, details.getProspectorDetails().getLastUpdated().get());
        }
        if (details.getJoinSelectivityDetails().getLastUpdated().isPresent()) {
            doc.append(JOIN_SELECTIVITY_DETAILS_KEY, details.getJoinSelectivityDetails().getLastUpdated().get());
        }
        if (details.getRyaStreamsDetails().isPresent()) {
            RyaDetails.RyaStreamsDetails ryaStreamsDetails = (RyaDetails.RyaStreamsDetails)details.getRyaStreamsDetails().get();
            Document ryaStreamsFields = new Document().append(RYA_STREAMS_HOSTNAME_KEY, (Object)ryaStreamsDetails.getHostname()).append(RYA_STREAMS_PORT_KEY, (Object)ryaStreamsDetails.getPort());
            doc.append(RYA_STREAMS_DETAILS_KEY, (Object)ryaStreamsFields);
        }
        return doc;
    }

    private static Document toDocument(RyaDetails.PCJIndexDetails pcjIndexDetails) {
        Objects.requireNonNull(pcjIndexDetails);
        Document doc = new Document();
        doc.append(PCJ_ENABLED_KEY, (Object)pcjIndexDetails.isEnabled());
        ArrayList<Document> pcjDetailsList = new ArrayList<Document>();
        for (RyaDetails.PCJIndexDetails.PCJDetails pcjDetails : pcjIndexDetails.getPCJDetails().values()) {
            pcjDetailsList.add(MongoDetailsAdapter.toDocument(pcjDetails));
        }
        doc.append(PCJ_PCJS_KEY, pcjDetailsList);
        return doc;
    }

    static Document toDocument(RyaDetails.PCJIndexDetails.PCJDetails pcjDetails) {
        Objects.requireNonNull(pcjDetails);
        Document doc = new Document();
        doc.append(PCJ_ID_KEY, (Object)pcjDetails.getId());
        if (pcjDetails.getUpdateStrategy().isPresent()) {
            doc.append(PCJ_UPDATE_STRAT_KEY, (Object)((RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy)pcjDetails.getUpdateStrategy().get()).name());
        }
        if (pcjDetails.getLastUpdateTime().isPresent()) {
            doc.append(PCJ_LAST_UPDATE_KEY, pcjDetails.getLastUpdateTime().get());
        }
        return doc;
    }

    public static RyaDetails toRyaDetails(Document doc) throws MalformedRyaDetailsException {
        Objects.requireNonNull(doc);
        try {
            RyaDetails.Builder builder = RyaDetails.builder().setRyaInstanceName(doc.getString((Object)INSTANCE_KEY)).setRyaVersion(doc.getString((Object)VERSION_KEY)).setEntityCentricIndexDetails(new RyaDetails.EntityCentricIndexDetails(doc.getBoolean((Object)ENTITY_DETAILS_KEY).booleanValue())).setPCJIndexDetails(MongoDetailsAdapter.getPCJIndexDetails(doc)).setTemporalIndexDetails(new RyaDetails.TemporalIndexDetails(doc.getBoolean((Object)TEMPORAL_DETAILS_KEY).booleanValue())).setFreeTextDetails(new RyaDetails.FreeTextIndexDetails(doc.getBoolean((Object)FREETEXT_DETAILS_KEY).booleanValue())).setProspectorDetails(new RyaDetails.ProspectorDetails(Optional.fromNullable((Object)doc.getDate((Object)PROSPECTOR_DETAILS_KEY)))).setJoinSelectivityDetails(new RyaDetails.JoinSelectivityDetails(Optional.fromNullable((Object)doc.getDate((Object)JOIN_SELECTIVITY_DETAILS_KEY))));
            if (doc.containsKey((Object)RYA_STREAMS_DETAILS_KEY)) {
                Document streamsObject = (Document)doc.get((Object)RYA_STREAMS_DETAILS_KEY, Document.class);
                String hostname = streamsObject.getString((Object)RYA_STREAMS_HOSTNAME_KEY);
                int port = streamsObject.getInteger((Object)RYA_STREAMS_PORT_KEY);
                builder.setRyaStreamsDetails(new RyaDetails.RyaStreamsDetails(hostname, port));
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new MalformedRyaDetailsException("Failed to make RyaDetail from Mongo Object, it is malformed.", e);
        }
    }

    private static RyaDetails.PCJIndexDetails.Builder getPCJIndexDetails(Document document) {
        Document pcjIndexDoc = (Document)document.get((Object)PCJ_DETAILS_KEY, Document.class);
        RyaDetails.PCJIndexDetails.Builder pcjBuilder = RyaDetails.PCJIndexDetails.builder();
        if (!pcjIndexDoc.getBoolean((Object)PCJ_ENABLED_KEY).booleanValue()) {
            pcjBuilder.setEnabled(Boolean.valueOf(false));
        } else {
            pcjBuilder.setEnabled(Boolean.valueOf(true));
            List pcjs = pcjIndexDoc.getList((Object)PCJ_PCJS_KEY, Document.class);
            if (pcjs != null) {
                for (Document pcj : pcjs) {
                    pcjBuilder.addPCJDetails(MongoDetailsAdapter.toPCJDetails(pcj));
                }
            }
        }
        return pcjBuilder;
    }

    static RyaDetails.PCJIndexDetails.PCJDetails.Builder toPCJDetails(Document doc) {
        Objects.requireNonNull(doc);
        RyaDetails.PCJIndexDetails.PCJDetails.Builder builder = RyaDetails.PCJIndexDetails.PCJDetails.builder().setId(doc.getString((Object)PCJ_ID_KEY));
        if (doc.containsKey((Object)PCJ_UPDATE_STRAT_KEY)) {
            builder.setUpdateStrategy(RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy.valueOf((String)doc.getString((Object)PCJ_UPDATE_STRAT_KEY)));
        }
        if (doc.containsKey((Object)PCJ_LAST_UPDATE_KEY)) {
            builder.setLastUpdateTime(doc.getDate((Object)PCJ_LAST_UPDATE_KEY));
        }
        return builder;
    }

    public static class MalformedRyaDetailsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MalformedRyaDetailsException(String message, Throwable e) {
            super(message, e);
        }
    }
}

