/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.document.visibility;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rya.mongodb.MongoDbRdfConstants;
import org.apache.rya.mongodb.document.util.DocumentVisibilityConversionException;
import org.apache.rya.mongodb.document.util.DocumentVisibilityUtil;
import org.apache.rya.mongodb.document.visibility.DocumentVisibility;
import org.bson.Document;

@DefaultAnnotation(value={NonNull.class})
public final class DocumentVisibilityAdapter {
    private static final Logger log = Logger.getLogger(DocumentVisibilityAdapter.class);
    public static final String DOCUMENT_VISIBILITY_KEY = "documentVisibility";

    private DocumentVisibilityAdapter() {
    }

    public static Document toDocument(byte[] expression) {
        DocumentVisibility dv = expression == null ? MongoDbRdfConstants.EMPTY_DV : new DocumentVisibility(expression);
        return DocumentVisibilityAdapter.toDocument(dv);
    }

    public static Document toDocument(DocumentVisibility documentVisibility) {
        DocumentVisibility dv = documentVisibility == null ? MongoDbRdfConstants.EMPTY_DV : documentVisibility;
        List<Object> dvList = null;
        try {
            dvList = DocumentVisibilityUtil.toMultidimensionalArray(dv);
        }
        catch (DocumentVisibilityConversionException e) {
            log.error((Object)"Unable to convert document visibility");
        }
        Document document = new Document(DOCUMENT_VISIBILITY_KEY, dvList);
        return document;
    }

    public static DocumentVisibility toDocumentVisibility(Document doc) throws MalformedDocumentVisibilityException {
        try {
            Object documentVisibilityObject = doc.get((Object)DOCUMENT_VISIBILITY_KEY);
            Object[] documentVisibilityArray = null;
            if (documentVisibilityObject instanceof Object[]) {
                documentVisibilityArray = (Object[])documentVisibilityObject;
            } else if (documentVisibilityObject instanceof List) {
                documentVisibilityArray = ((List)documentVisibilityObject).toArray();
            }
            String documentVisibilityString = DocumentVisibilityUtil.multidimensionalArrayToBooleanString(documentVisibilityArray);
            DocumentVisibility dv = documentVisibilityString == null ? MongoDbRdfConstants.EMPTY_DV : new DocumentVisibility(documentVisibilityString);
            return dv;
        }
        catch (Exception e) {
            throw new MalformedDocumentVisibilityException("Failed to make Document Visibility from Mongo Object, it is malformed.", e);
        }
    }

    public static class MalformedDocumentVisibilityException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MalformedDocumentVisibilityException(String message, Throwable e) {
            super(message, e);
        }
    }
}

