/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.document.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.log4j.Logger;
import org.apache.rya.mongodb.MongoDbRdfConstants;
import org.apache.rya.mongodb.document.util.DisjunctiveNormalFormConverter;
import org.apache.rya.mongodb.document.util.DocumentVisibilityConversionException;
import org.apache.rya.mongodb.document.visibility.DocumentVisibility;

public final class DocumentVisibilityUtil {
    private static final Logger log = Logger.getLogger(DocumentVisibilityUtil.class);

    private DocumentVisibilityUtil() {
    }

    public static List<Object> toMultidimensionalArray(String booleanString) throws DocumentVisibilityConversionException {
        DocumentVisibility dv = new DocumentVisibility(booleanString);
        return DocumentVisibilityUtil.toMultidimensionalArray(dv);
    }

    public static List<Object> toMultidimensionalArray(DocumentVisibility dv) throws DocumentVisibilityConversionException {
        Preconditions.checkNotNull((Object)((Object)dv));
        byte[] expression = dv.flatten();
        DocumentVisibility flattenedDv = DisjunctiveNormalFormConverter.createDnfDocumentVisibility(expression);
        List<Object> result = DocumentVisibilityUtil.toMultidimensionalArray(flattenedDv.getParseTree(), flattenedDv.getExpression());
        if (!result.isEmpty() && result.get(0) instanceof String) {
            ArrayList<Object> formattedResult = new ArrayList<Object>();
            formattedResult.add(result);
            return formattedResult;
        }
        return result;
    }

    public static List<Object> toMultidimensionalArray(ColumnVisibility.Node node, byte[] expression) throws DocumentVisibilityConversionException {
        Preconditions.checkNotNull((Object)node);
        ArrayList<Object> array = new ArrayList<Object>();
        if (node.getChildren().isEmpty() && node.getType() == ColumnVisibility.NodeType.TERM) {
            String data = DocumentVisibilityUtil.getTermNodeData(node, expression);
            array.add(data);
        }
        log.trace((Object)("Children size: " + node.getChildren().size() + " Type: " + node.getType()));
        block4: for (ColumnVisibility.Node child : node.getChildren()) {
            switch (child.getType()) {
                case EMPTY: 
                case TERM: {
                    String data = child.getType() == ColumnVisibility.NodeType.TERM ? DocumentVisibilityUtil.getTermNodeData(child, expression) : "";
                    if (node.getType() == ColumnVisibility.NodeType.OR) {
                        array.add(Lists.newArrayList((Object[])new String[]{data}));
                        continue block4;
                    }
                    array.add(data);
                    continue block4;
                }
                case OR: 
                case AND: {
                    array.add(DocumentVisibilityUtil.toMultidimensionalArray(child, expression));
                    continue block4;
                }
            }
            throw new DocumentVisibilityConversionException("Unknown type: " + child.getType());
        }
        return array;
    }

    public static String nodeToBooleanString(ColumnVisibility.Node node, byte[] expression) throws DocumentVisibilityConversionException {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        if (node.getType() == ColumnVisibility.NodeType.TERM) {
            String data = DocumentVisibilityUtil.getTermNodeData(node, expression);
            sb.append(data);
        }
        if (node.getType() == ColumnVisibility.NodeType.AND) {
            sb.append("(");
        }
        block6: for (ColumnVisibility.Node child : node.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else if (node.getType() == ColumnVisibility.NodeType.OR) {
                sb.append("|");
            } else if (node.getType() == ColumnVisibility.NodeType.AND) {
                sb.append("&");
            }
            switch (child.getType()) {
                case EMPTY: {
                    sb.append("");
                    continue block6;
                }
                case TERM: {
                    String data = DocumentVisibilityUtil.getTermNodeData(child, expression);
                    sb.append(data);
                    continue block6;
                }
                case OR: {
                    sb.append("(");
                    sb.append(DocumentVisibilityUtil.nodeToBooleanString(child, expression));
                    sb.append(")");
                    continue block6;
                }
                case AND: {
                    sb.append(DocumentVisibilityUtil.nodeToBooleanString(child, expression));
                    continue block6;
                }
            }
            throw new DocumentVisibilityConversionException("Unknown type: " + child.getType());
        }
        if (node.getType() == ColumnVisibility.NodeType.AND) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String multidimensionalArrayToBooleanString(Object[] object) {
        String booleanString = DocumentVisibilityUtil.multidimensionalArrayToBooleanStringInternal(object);
        DocumentVisibility dv = DisjunctiveNormalFormConverter.createDnfDocumentVisibility(booleanString);
        byte[] bytes = dv.flatten();
        String result = new String(bytes, Charsets.UTF_8);
        return result;
    }

    private static String multidimensionalArrayToBooleanStringInternal(Object[] object) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        boolean isAnd = false;
        for (Object child : object) {
            Object[] obj;
            if (child instanceof String) {
                isAnd = true;
                if (count > 0) {
                    sb.append("&");
                }
                sb.append(child);
            } else if (child instanceof Object[]) {
                if (count > 0 && isAnd) {
                    sb.append("&");
                }
                obj = (Object[])child;
                sb.append("(");
                sb.append(DocumentVisibilityUtil.multidimensionalArrayToBooleanStringInternal(obj));
                sb.append(")");
            } else if (child instanceof List) {
                if (count > 0 && isAnd) {
                    sb.append("&");
                }
                obj = (List)child;
                sb.append("(");
                sb.append(DocumentVisibilityUtil.multidimensionalArrayToBooleanStringInternal(obj.toArray()));
                sb.append(")");
            }
            if (object.length > 1 && count + 1 < object.length && !isAnd) {
                sb.append("|");
            }
            ++count;
        }
        return sb.toString();
    }

    public static String addQuotes(String data, boolean addQuotes) {
        if (addQuotes) {
            return "\"" + data + "\"";
        }
        return data;
    }

    public static String getTermNodeData(ColumnVisibility.Node node, byte[] expression) {
        boolean isQuotedTerm = expression[node.getTermStart()] == 34;
        ByteSequence bs = node.getTerm(expression);
        String data = DocumentVisibilityUtil.addQuotes(new String(bs.toArray(), Charsets.UTF_8), isQuotedTerm);
        return data;
    }

    public static boolean doesUserHaveDocumentAccess(Authorizations authorizations, byte[] documentVisibilityExpression) {
        byte[] expression = documentVisibilityExpression != null ? documentVisibilityExpression : MongoDbRdfConstants.EMPTY_DV.getExpression();
        DocumentVisibility documentVisibility = new DocumentVisibility(expression);
        return DocumentVisibilityUtil.doesUserHaveDocumentAccess(authorizations, documentVisibility);
    }

    public static boolean doesUserHaveDocumentAccess(Authorizations authorizations, DocumentVisibility documentVisibility) {
        return DocumentVisibilityUtil.doesUserHaveDocumentAccess(authorizations, documentVisibility, true);
    }

    public static boolean doesUserHaveDocumentAccess(Authorizations authorizations, DocumentVisibility documentVisibility, boolean doesEmptyAccessPass) {
        Authorizations userAuths = authorizations != null ? authorizations : MongoDbRdfConstants.ALL_AUTHORIZATIONS;
        VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(userAuths);
        boolean accept = false;
        if (doesEmptyAccessPass && MongoDbRdfConstants.ALL_AUTHORIZATIONS.equals((Object)userAuths)) {
            accept = true;
        } else {
            try {
                accept = visibilityEvaluator.evaluate((ColumnVisibility)documentVisibility);
            }
            catch (VisibilityParseException e) {
                log.error((Object)"Could not parse document visibility.");
            }
        }
        return accept;
    }

    public static List<Object> convertObjectArrayToList(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object child : array) {
            if (child instanceof Object[]) {
                list.add(DocumentVisibilityUtil.convertObjectArrayToList((Object[])child));
                continue;
            }
            list.add(child);
        }
        return list;
    }
}

