/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.document.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.rya.mongodb.document.util.DocumentVisibilityUtil;
import org.apache.rya.mongodb.document.visibility.DocumentVisibility;

public final class DisjunctiveNormalFormConverter {
    private static final Logger log = Logger.getLogger(DisjunctiveNormalFormConverter.class);

    private DisjunctiveNormalFormConverter() {
    }

    public static DocumentVisibility createDnfDocumentVisibility(String expression) {
        return DisjunctiveNormalFormConverter.createDnfDocumentVisibility(expression.getBytes(StandardCharsets.UTF_8));
    }

    public static DocumentVisibility createDnfDocumentVisibility(byte[] expression) {
        DocumentVisibility documentVisibility = new DocumentVisibility(expression);
        DocumentVisibility dnfDv = DisjunctiveNormalFormConverter.convertToDisjunctiveNormalForm(documentVisibility);
        return dnfDv;
    }

    public static DocumentVisibility convertToDisjunctiveNormalForm(DocumentVisibility documentVisibility) {
        List<String> terms = DisjunctiveNormalFormConverter.findNodeTerms(documentVisibility.getParseTree(), documentVisibility.getExpression());
        byte[][] truthTable = DisjunctiveNormalFormConverter.createTruthTableInputs(terms);
        ArrayList termRowsThatPass = new ArrayList();
        for (byte[] byArray : truthTable) {
            List existingTermRowThatPassed;
            ArrayList<String> termRowToCheck = new ArrayList<String>();
            for (int i = 0; i < byArray.length; ++i) {
                byte entry = byArray[i];
                if (entry != 1) continue;
                termRowToCheck.add(terms.get(i));
            }
            ArrayList<String> authList = new ArrayList<String>();
            Iterator entry = termRowToCheck.iterator();
            while (entry.hasNext()) {
                String auth;
                String formattedAuth = auth = (String)entry.next();
                formattedAuth = StringUtils.removeStart((String)formattedAuth, (String)"\"");
                formattedAuth = StringUtils.removeEnd((String)formattedAuth, (String)"\"");
                authList.add(formattedAuth);
            }
            Authorizations auths = new Authorizations(authList.toArray(new String[0]));
            boolean hasAccess = DocumentVisibilityUtil.doesUserHaveDocumentAccess(auths, documentVisibility, false);
            if (!hasAccess) continue;
            boolean alreadyCoveredBySimplerTerms = false;
            Iterator iterator = termRowsThatPass.iterator();
            while (iterator.hasNext() && !(alreadyCoveredBySimplerTerms = termRowToCheck.containsAll(existingTermRowThatPassed = (List)iterator.next()))) {
            }
            if (alreadyCoveredBySimplerTerms) continue;
            termRowsThatPass.add(termRowToCheck);
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        boolean hasMultipleGroups = termRowsThatPass.size() > 1;
        for (List termRowThatPassed : termRowsThatPass) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("|");
            }
            if (hasMultipleGroups && termRowThatPassed.size() > 1) {
                sb.append("(");
            }
            sb.append(Joiner.on((String)"&").join((Iterable)termRowThatPassed));
            if (!hasMultipleGroups || termRowThatPassed.size() <= 1) continue;
            sb.append(")");
        }
        log.trace((Object)sb.toString());
        DocumentVisibility documentVisibility2 = new DocumentVisibility(sb.toString());
        return documentVisibility2;
    }

    public static List<String> findNodeTerms(ColumnVisibility.Node node, byte[] expression) {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        if (node.getType() == ColumnVisibility.NodeType.TERM) {
            String data = DocumentVisibilityUtil.getTermNodeData(node, expression);
            terms.add(data);
        }
        for (ColumnVisibility.Node child : node.getChildren()) {
            switch (node.getType()) {
                case AND: 
                case OR: {
                    terms.addAll(DisjunctiveNormalFormConverter.findNodeTerms(child, expression));
                    break;
                }
            }
        }
        return Collections.unmodifiableList(Lists.newArrayList(terms));
    }

    public static byte[][] createTruthTableInputs(ColumnVisibility.Node node, byte[] expression) {
        List<String> terms = DisjunctiveNormalFormConverter.findNodeTerms(node, expression);
        return DisjunctiveNormalFormConverter.createTruthTableInputs(terms);
    }

    public static byte[][] createTruthTableInputs(List<String> terms) {
        return DisjunctiveNormalFormConverter.createTruthTableInputs(terms.size());
    }

    public static byte[][] createTruthTableInputs(int termNumber) {
        int numColumns = termNumber;
        int numRows = (int)Math.pow(2.0, numColumns);
        byte[][] truthTable = new byte[numRows][numColumns];
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numColumns; ++col) {
                int digitOrderPosition = numColumns - 1 - col;
                int power = (int)Math.pow(2.0, digitOrderPosition);
                int toggle = row / power % 2;
                truthTable[row][col] = (byte)toggle;
            }
        }
        log.trace((Object)("Truth table inputs: " + Arrays.deepToString((Object[])truthTable)));
        return truthTable;
    }
}

