/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.document.operators.query;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.Document;

public class QueryBuilder {
    private final Document query = new Document();
    private String currentKey;
    private boolean hasNot;

    public static QueryBuilder start() {
        return new QueryBuilder();
    }

    public static QueryBuilder start(String key) {
        return new QueryBuilder().put(key);
    }

    public QueryBuilder put(String key) {
        this.currentKey = key;
        if (this.query.get((Object)key) == null) {
            this.query.put(this.currentKey, (Object)new NullObject());
        }
        return this;
    }

    public QueryBuilder and(String key) {
        return this.put(key);
    }

    public QueryBuilder greaterThan(Object object) {
        this.addOperand("$gt", object);
        return this;
    }

    public QueryBuilder greaterThanEquals(Object object) {
        this.addOperand("$gte", object);
        return this;
    }

    public QueryBuilder lessThan(Object object) {
        this.addOperand("$lt", object);
        return this;
    }

    public QueryBuilder lessThanEquals(Object object) {
        this.addOperand("$lte", object);
        return this;
    }

    public QueryBuilder is(Object object) {
        this.addOperand(null, object);
        return this;
    }

    public QueryBuilder notEquals(Object object) {
        this.addOperand("$ne", object);
        return this;
    }

    public QueryBuilder in(Object object) {
        this.addOperand("$in", object);
        return this;
    }

    public QueryBuilder notIn(Object object) {
        this.addOperand("$nin", object);
        return this;
    }

    public QueryBuilder mod(Object object) {
        this.addOperand("$mod", object);
        return this;
    }

    public QueryBuilder all(Object object) {
        this.addOperand("$all", object);
        return this;
    }

    public QueryBuilder size(Object object) {
        this.addOperand("$size", object);
        return this;
    }

    public QueryBuilder exists(Object object) {
        this.addOperand("$exists", object);
        return this;
    }

    public QueryBuilder regex(Pattern regex) {
        this.addOperand(null, regex);
        return this;
    }

    public QueryBuilder elemMatch(Document match) {
        this.addOperand("$elemMatch", match);
        return this;
    }

    public QueryBuilder withinCenter(double x, double y, double radius) {
        this.addOperand("$within", new Document("$center", Arrays.asList(Arrays.asList(x, y), radius)));
        return this;
    }

    public QueryBuilder near(double x, double y) {
        this.addOperand("$near", Arrays.asList(x, y));
        return this;
    }

    public QueryBuilder near(double x, double y, double maxDistance) {
        this.addOperand("$near", Arrays.asList(x, y));
        this.addOperand("$maxDistance", maxDistance);
        return this;
    }

    public QueryBuilder nearSphere(double longitude, double latitude) {
        this.addOperand("$nearSphere", Arrays.asList(longitude, latitude));
        return this;
    }

    public QueryBuilder nearSphere(double longitude, double latitude, double maxDistance) {
        this.addOperand("$nearSphere", Arrays.asList(longitude, latitude));
        this.addOperand("$maxDistance", maxDistance);
        return this;
    }

    public QueryBuilder withinCenterSphere(double longitude, double latitude, double maxDistance) {
        this.addOperand("$within", new Document("$centerSphere", Arrays.asList(Arrays.asList(longitude, latitude), maxDistance)));
        return this;
    }

    public QueryBuilder withinBox(double x, double y, double x2, double y2) {
        this.addOperand("$within", new Document("$box", (Object)new Object[]{new Double[]{x, y}, new Double[]{x2, y2}}));
        return this;
    }

    public QueryBuilder withinPolygon(List<Double[]> points) {
        Assertions.notNull((String)"points", points);
        if (points.isEmpty() || points.size() < 3) {
            throw new IllegalArgumentException("Polygon insufficient number of vertices defined");
        }
        this.addOperand("$within", new Document("$polygon", this.convertToListOfLists(points)));
        return this;
    }

    private List<List<Double>> convertToListOfLists(List<Double[]> points) {
        ArrayList<List<Double>> listOfLists = new ArrayList<List<Double>>(points.size());
        for (Double[] cur : points) {
            ArrayList list = new ArrayList(cur.length);
            Collections.addAll(list, cur);
            listOfLists.add(list);
        }
        return listOfLists;
    }

    public QueryBuilder text(String search) {
        return this.text(search, null);
    }

    public QueryBuilder text(String search, @Nullable String language) {
        if (this.currentKey != null) {
            throw new QueryBuilderException("The text operand may only occur at the top-level of a query. It does not apply to a specific element, but rather to a document as a whole.");
        }
        this.put("$text");
        this.addOperand("$search", search);
        if (language != null) {
            this.addOperand("$language", language);
        }
        return this;
    }

    public QueryBuilder not() {
        this.hasNot = true;
        return this;
    }

    public QueryBuilder or(Document ... ors) {
        ArrayList l = this.query.getList((Object)"$or", Object.class);
        if (l == null) {
            l = new ArrayList();
            this.query.put("$or", l);
        }
        Collections.addAll(l, ors);
        return this;
    }

    public QueryBuilder and(Document ... ands) {
        ArrayList l = this.query.getList((Object)"$and", Object.class);
        if (l == null) {
            l = new ArrayList();
            this.query.put("$and", l);
        }
        Collections.addAll(l, ands);
        return this;
    }

    public Document get() {
        for (String key : this.query.keySet()) {
            if (!(this.query.get((Object)key) instanceof NullObject)) continue;
            throw new QueryBuilderException("No operand for key:" + key);
        }
        return this.query;
    }

    private void addOperand(@Nullable String op, Object value) {
        Document operand;
        Object valueToPut = value;
        if (op == null) {
            if (this.hasNot) {
                valueToPut = new Document("$not", valueToPut);
                this.hasNot = false;
            }
            this.query.put(this.currentKey, valueToPut);
            return;
        }
        Object storedValue = this.query.get((Object)this.currentKey);
        if (!(storedValue instanceof Document)) {
            operand = new Document();
            if (this.hasNot) {
                Document notOperand = new Document("$not", (Object)operand);
                this.query.put(this.currentKey, (Object)notOperand);
                this.hasNot = false;
            } else {
                this.query.put(this.currentKey, (Object)operand);
            }
        } else {
            operand = (Document)this.query.get((Object)this.currentKey);
            if (operand.get((Object)"$not") != null) {
                operand = (Document)operand.get((Object)"$not");
            }
        }
        operand.put(op, valueToPut);
    }

    private static class NullObject {
        private NullObject() {
        }
    }

    static class QueryBuilderException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        QueryBuilderException(String message) {
            super(message);
        }
    }
}

