/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.document.operators.aggregation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.rya.mongodb.MongoDbRdfConstants;
import org.apache.rya.mongodb.document.operators.aggregation.PipelineOperators;
import org.apache.rya.mongodb.document.operators.aggregation.SetOperators;
import org.apache.rya.mongodb.document.operators.aggregation.VariableOperators;
import org.apache.rya.mongodb.document.operators.query.ArrayOperators;
import org.apache.rya.mongodb.document.operators.query.ComparisonOperators;
import org.apache.rya.mongodb.document.operators.query.LogicalOperators;
import org.apache.rya.mongodb.document.util.AuthorizationsUtil;
import org.bson.Document;

public final class AggregationUtil {
    private AggregationUtil() {
    }

    public static List<Document> createRedactPipeline(Authorizations authorizations) {
        if (MongoDbRdfConstants.ALL_AUTHORIZATIONS.equals((Object)authorizations)) {
            return Lists.newArrayList();
        }
        List<String> authList = AuthorizationsUtil.getAuthorizationsStrings(authorizations);
        String documentVisibilityField = "$documentVisibility";
        String mapVariableCursorName = "dvItemCursorTag";
        Document anyElementTrue = SetOperators.anyElementTrue(VariableOperators.map("$documentVisibility", "dvItemCursorTag", SetOperators.setIsSubsetNullSafe("$$dvItemCursorTag", authList)));
        Document isFieldSizeZero = ComparisonOperators.eq(ArrayOperators.size("$documentVisibility"), 0);
        Document orExpression = LogicalOperators.or(anyElementTrue, isFieldSizeZero, new Document[0]);
        ArrayList<Document> pipeline = new ArrayList<Document>();
        pipeline.add(PipelineOperators.redact(orExpression, PipelineOperators.RedactAggregationResult.DESCEND, PipelineOperators.RedactAggregationResult.PRUNE));
        return pipeline;
    }
}

