/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.dao;

import com.mongodb.client.MongoCollection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.StatementMetadata;
import org.apache.rya.api.persist.query.RyaQuery;
import org.apache.rya.api.utils.LiteralLanguageUtils;
import org.apache.rya.mongodb.dao.MongoDBStorageStrategy;
import org.apache.rya.mongodb.document.visibility.DocumentVisibility;
import org.apache.rya.mongodb.document.visibility.DocumentVisibilityAdapter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class SimpleMongoDBStorageStrategy
implements MongoDBStorageStrategy<RyaStatement> {
    private static final Logger LOG = Logger.getLogger(SimpleMongoDBStorageStrategy.class);
    public static final String ID = "_id";
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_TYPE_VALUE = XMLSchema.ANYURI.stringValue();
    public static final String CONTEXT = "context";
    public static final String PREDICATE = "predicate";
    public static final String PREDICATE_HASH = "predicate_hash";
    public static final String OBJECT = "object";
    public static final String OBJECT_HASH = "object_hash";
    public static final String OBJECT_LANGUAGE = "object_language";
    public static final String SUBJECT = "subject";
    public static final String SUBJECT_HASH = "subject_hash";
    public static final String TIMESTAMP = "insertTimestamp";
    public static final String STATEMENT_METADATA = "statementMetadata";
    public static final String DOCUMENT_VISIBILITY = "documentVisibility";
    protected SimpleValueFactory factory = SimpleValueFactory.getInstance();

    public static String hash(String value) {
        return DigestUtils.sha256Hex((String)value);
    }

    @Override
    public void createIndices(MongoCollection<Document> coll) {
        Document doc = new Document();
        doc.put(SUBJECT_HASH, (Object)1);
        doc.put(PREDICATE_HASH, (Object)1);
        doc.put(OBJECT_HASH, (Object)1);
        doc.put(OBJECT_TYPE, (Object)1);
        doc.put(OBJECT_LANGUAGE, (Object)1);
        coll.createIndex((Bson)doc);
        doc = new Document(PREDICATE_HASH, (Object)1);
        doc.put(OBJECT_HASH, (Object)1);
        doc.put(OBJECT_TYPE, (Object)1);
        doc.put(OBJECT_LANGUAGE, (Object)1);
        coll.createIndex((Bson)doc);
        doc = new Document(OBJECT_HASH, (Object)1);
        doc.put(OBJECT_TYPE, (Object)1);
        doc.put(OBJECT_LANGUAGE, (Object)1);
        doc.put(SUBJECT_HASH, (Object)1);
        coll.createIndex((Bson)doc);
    }

    @Override
    public Document getQuery(RyaStatement stmt) {
        RyaIRI subject = stmt.getSubject();
        RyaIRI predicate = stmt.getPredicate();
        RyaType object = stmt.getObject();
        RyaIRI context = stmt.getContext();
        Document query = new Document();
        if (subject != null) {
            query.append(SUBJECT_HASH, (Object)SimpleMongoDBStorageStrategy.hash(subject.getData()));
        }
        if (object != null) {
            query.append(OBJECT_HASH, (Object)SimpleMongoDBStorageStrategy.hash(object.getData()));
            query.append(OBJECT_TYPE, (Object)object.getDataType().toString());
            query.append(OBJECT_LANGUAGE, (Object)object.getLanguage());
        }
        if (predicate != null) {
            query.append(PREDICATE_HASH, (Object)SimpleMongoDBStorageStrategy.hash(predicate.getData()));
        }
        if (context != null) {
            query.append(CONTEXT, (Object)context.getData());
        }
        return query;
    }

    @Override
    public RyaStatement deserializeDocument(Document queryResult) {
        String subject = (String)queryResult.get((Object)SUBJECT);
        String object = (String)queryResult.get((Object)OBJECT);
        String objectType = (String)queryResult.get((Object)OBJECT_TYPE);
        String objectLanguage = (String)queryResult.get((Object)OBJECT_LANGUAGE);
        String predicate = (String)queryResult.get((Object)PREDICATE);
        String context = (String)queryResult.get((Object)CONTEXT);
        DocumentVisibility documentVisibility = null;
        try {
            documentVisibility = DocumentVisibilityAdapter.toDocumentVisibility(queryResult);
        }
        catch (DocumentVisibilityAdapter.MalformedDocumentVisibilityException e) {
            throw new RuntimeException("Unable to convert document visibility", e);
        }
        Long timestamp = (Long)queryResult.get((Object)TIMESTAMP);
        String statementMetadata = (String)queryResult.get((Object)STATEMENT_METADATA);
        Object objectRya = null;
        String validatedLanguage = LiteralLanguageUtils.validateLanguage((String)objectLanguage, (IRI)this.factory.createIRI(objectType));
        objectRya = objectType.equalsIgnoreCase(XMLSchema.ANYURI.stringValue()) ? new RyaIRI(object) : (validatedLanguage != null ? new RyaType(this.factory.createIRI(objectType), object, validatedLanguage) : new RyaType(this.factory.createIRI(objectType), object));
        RyaStatement statement = !context.isEmpty() ? new RyaStatement(new RyaIRI(subject), new RyaIRI(predicate), (RyaType)objectRya, new RyaIRI(context)) : new RyaStatement(new RyaIRI(subject), new RyaIRI(predicate), (RyaType)objectRya);
        statement.setColumnVisibility(documentVisibility.flatten());
        if (timestamp != null) {
            statement.setTimestamp(timestamp);
        }
        if (statementMetadata != null) {
            try {
                StatementMetadata metadata = new StatementMetadata(statementMetadata);
                statement.setStatementMetadata(metadata);
            }
            catch (Exception ex) {
                LOG.debug((Object)"Error deserializing metadata for statement", (Throwable)ex);
            }
        }
        return statement;
    }

    @Override
    public Document serialize(RyaStatement statement) {
        return this.serializeInternal(statement);
    }

    public Document serializeInternal(RyaStatement statement) {
        String context = "";
        if (statement.getContext() != null) {
            context = statement.getContext().getData();
        }
        String validatedLanguage = LiteralLanguageUtils.validateLanguage((String)statement.getObject().getLanguage(), (IRI)statement.getObject().getDataType());
        String id = statement.getSubject().getData() + " " + statement.getPredicate().getData() + " " + statement.getObject().getData() + (validatedLanguage != null ? " " + validatedLanguage : "") + " " + context;
        byte[] bytes = id.getBytes(StandardCharsets.UTF_8);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            bytes = digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Unable to perform SHA-1 on the ID, defaulting to raw bytes.", (Throwable)e);
        }
        if (statement.getMetadata() == null) {
            statement.setStatementMetadata(StatementMetadata.EMPTY_METADATA);
        }
        Document dvObject = DocumentVisibilityAdapter.toDocument(statement.getColumnVisibility());
        Document doc = new Document(ID, (Object)new String(Hex.encodeHex((byte[])bytes))).append(SUBJECT, (Object)statement.getSubject().getData()).append(SUBJECT_HASH, (Object)SimpleMongoDBStorageStrategy.hash(statement.getSubject().getData())).append(PREDICATE, (Object)statement.getPredicate().getData()).append(PREDICATE_HASH, (Object)SimpleMongoDBStorageStrategy.hash(statement.getPredicate().getData())).append(OBJECT, (Object)statement.getObject().getData()).append(OBJECT_HASH, (Object)SimpleMongoDBStorageStrategy.hash(statement.getObject().getData())).append(OBJECT_TYPE, (Object)statement.getObject().getDataType().toString()).append(OBJECT_LANGUAGE, (Object)statement.getObject().getLanguage()).append(CONTEXT, (Object)context).append(STATEMENT_METADATA, (Object)statement.getMetadata().toString()).append(DOCUMENT_VISIBILITY, dvObject.get((Object)DOCUMENT_VISIBILITY)).append(TIMESTAMP, (Object)statement.getTimestamp());
        return doc;
    }

    @Override
    public Document getQuery(RyaQuery ryaQuery) {
        return this.getQuery(ryaQuery.getQuery());
    }
}

