/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.dao;

import com.mongodb.DBCollection;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.dao.MongoDBNamespaceManager;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Namespace;

public class SimpleMongoDBNamespaceManager
implements MongoDBNamespaceManager {
    private static final String ID = "_id";
    private static final String PREFIX = "prefix";
    private static final String NAMESPACE = "namespace";
    private StatefulMongoDBRdfConfiguration conf;
    private final MongoCollection<Document> nsColl;

    public SimpleMongoDBNamespaceManager(MongoCollection<Document> nameSpaceCollection) {
        this.nsColl = nameSpaceCollection;
    }

    @Override
    public void createIndices(DBCollection coll) {
        coll.createIndex(PREFIX);
        coll.createIndex(NAMESPACE);
    }

    public void setConf(StatefulMongoDBRdfConfiguration conf) {
        this.conf = conf;
    }

    public StatefulMongoDBRdfConfiguration getConf() {
        return this.conf;
    }

    public void addNamespace(String prefix, String namespace) throws RyaDAOException {
        String id = prefix;
        byte[] bytes = id.getBytes(StandardCharsets.UTF_8);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            bytes = digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        Document doc = new Document(ID, (Object)new String(Hex.encodeHex((byte[])bytes))).append(PREFIX, (Object)prefix).append(NAMESPACE, (Object)namespace);
        this.nsColl.insertOne((Object)doc);
    }

    public String getNamespace(String prefix) throws RyaDAOException {
        Document query = new Document().append(PREFIX, (Object)prefix);
        FindIterable iterable = this.nsColl.find((Bson)query);
        String nameSpace = prefix;
        try (MongoCursor cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                Document obj = (Document)cursor.next();
                nameSpace = (String)obj.get((Object)NAMESPACE);
            }
        }
        return nameSpace;
    }

    public void removeNamespace(String prefix) throws RyaDAOException {
        Document query = new Document().append(PREFIX, (Object)prefix);
        this.nsColl.deleteMany((Bson)query);
    }

    public CloseableIteration<? extends Namespace, RyaDAOException> iterateNamespace() throws RyaDAOException {
        FindIterable iterable = this.nsColl.find();
        MongoCursor cursor = iterable.iterator();
        return new MongoCursorIteration((MongoCursor<Document>)cursor);
    }

    public class MongoCursorIteration
    implements CloseableIteration<Namespace, RyaDAOException> {
        private final MongoCursor<Document> cursor;

        public MongoCursorIteration(MongoCursor<Document> cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() throws RyaDAOException {
            return this.cursor.hasNext();
        }

        public Namespace next() throws RyaDAOException {
            Document ns = (Document)this.cursor.next();
            String namespace = (String)ns.get((Object)SimpleMongoDBNamespaceManager.NAMESPACE);
            String prefix = (String)ns.get((Object)SimpleMongoDBNamespaceManager.PREFIX);
            NamespaceImplementation temp = new NamespaceImplementation(namespace, prefix);
            return temp;
        }

        public void remove() throws RyaDAOException {
            this.next();
        }

        public void close() throws RyaDAOException {
            this.cursor.close();
        }
    }

    public class NamespaceImplementation
    implements Namespace {
        private static final long serialVersionUID = 1L;
        private final String namespace;
        private final String prefix;

        public NamespaceImplementation(String namespace, String prefix) {
            this.namespace = namespace;
            this.prefix = prefix;
        }

        public int compareTo(Namespace o) {
            if (!this.namespace.equalsIgnoreCase(o.getName())) {
                return this.namespace.compareTo(o.getName());
            }
            if (!this.prefix.equalsIgnoreCase(o.getPrefix())) {
                return this.prefix.compareTo(o.getPrefix());
            }
            return 0;
        }

        public String getName() {
            return this.namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

