/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.batch;

import org.apache.hadoop.conf.Configuration;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterConfig;

public final class MongoDbBatchWriterUtils {
    public static final String BATCH_SIZE_TAG = "rya.mongodb.dao.batchwriter.size";
    public static final String BATCH_FLUSH_TIME_MS_TAG = "rya.mongodb.dao.batchwriter.flushtime";

    private MongoDbBatchWriterUtils() {
    }

    public static int getConfigBatchSize(Configuration conf) {
        return conf.getInt(BATCH_SIZE_TAG, 50000);
    }

    public static long getConfigBatchFlushTimeMs(Configuration conf) {
        return conf.getLong(BATCH_FLUSH_TIME_MS_TAG, 100L);
    }

    public static MongoDbBatchWriterConfig getMongoDbBatchWriterConfig(Configuration conf) {
        int batchSize = MongoDbBatchWriterUtils.getConfigBatchSize(conf);
        long batchFlushTimeMs = MongoDbBatchWriterUtils.getConfigBatchFlushTimeMs(conf);
        MongoDbBatchWriterConfig mongoDbBatchWriterConfig = new MongoDbBatchWriterConfig();
        mongoDbBatchWriterConfig.setBatchSize(batchSize);
        mongoDbBatchWriterConfig.setBatchFlushTimeMs(batchFlushTimeMs);
        return mongoDbBatchWriterConfig;
    }
}

