/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.batch;

import com.google.common.base.Preconditions;

public class MongoDbBatchWriterConfig {
    public static final int DEFAULT_BATCH_SIZE = 50000;
    private Integer batchSize = null;
    public static final long DEFAULT_BATCH_FLUSH_TIME_MS = 100L;
    private Long batchFlushTimeMs = null;

    public int getBatchSize() {
        return this.batchSize != null ? this.batchSize : 50000;
    }

    public MongoDbBatchWriterConfig setBatchSize(int batchSize) {
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be positive.");
        this.batchSize = batchSize;
        return this;
    }

    public long getBatchFlushTimeMs() {
        return this.batchFlushTimeMs != null ? this.batchFlushTimeMs : 100L;
    }

    public MongoDbBatchWriterConfig setBatchFlushTimeMs(long batchFlushTimeMs) {
        Preconditions.checkArgument((batchFlushTimeMs >= 0L ? 1 : 0) != 0, (Object)"Batch flush time must be non-negative.");
        this.batchFlushTimeMs = batchFlushTimeMs;
        return this;
    }
}

