/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.aggregation;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Arrays;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.aggregation.AggregationPipelineQueryNode;
import org.bson.Document;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class SparqlToPipelineTransformVisitor
extends AbstractQueryModelVisitor<Exception> {
    private final MongoCollection<Document> inputCollection;

    public SparqlToPipelineTransformVisitor(MongoCollection<Document> inputCollection) {
        this.inputCollection = (MongoCollection)Preconditions.checkNotNull(inputCollection);
    }

    public SparqlToPipelineTransformVisitor(StatefulMongoDBRdfConfiguration conf) {
        Preconditions.checkNotNull((Object)((Object)conf));
        MongoClient mongo = conf.getMongoClient();
        MongoDatabase db = mongo.getDatabase(conf.getMongoDBName());
        this.inputCollection = db.getCollection(conf.getTriplesCollectionName());
    }

    public void meet(StatementPattern sp) {
        sp.replaceWith((QueryModelNode)new AggregationPipelineQueryNode(this.inputCollection, sp));
    }

    public void meet(Join join) throws Exception {
        AggregationPipelineQueryNode pipelineNode = null;
        StatementPattern joinWithSP = null;
        if (join.getRightArg() instanceof StatementPattern) {
            join.getLeftArg().visit((QueryModelVisitor)this);
            if (join.getLeftArg() instanceof AggregationPipelineQueryNode) {
                pipelineNode = (AggregationPipelineQueryNode)join.getLeftArg();
                joinWithSP = (StatementPattern)join.getRightArg();
            }
        } else if (join.getLeftArg() instanceof StatementPattern) {
            join.getRightArg().visit((QueryModelVisitor)this);
            if (join.getRightArg() instanceof AggregationPipelineQueryNode) {
                pipelineNode = (AggregationPipelineQueryNode)join.getRightArg();
                joinWithSP = (StatementPattern)join.getLeftArg();
            }
        } else {
            join.visitChildren((QueryModelVisitor)this);
        }
        if (pipelineNode != null && joinWithSP != null && pipelineNode.joinWith(joinWithSP)) {
            join.replaceWith((QueryModelNode)pipelineNode);
        }
    }

    public void meet(Projection projectionNode) throws Exception {
        AggregationPipelineQueryNode pipelineNode;
        projectionNode.visitChildren((QueryModelVisitor)this);
        if (projectionNode.getArg() instanceof AggregationPipelineQueryNode && projectionNode.getParentNode() != null && (pipelineNode = (AggregationPipelineQueryNode)projectionNode.getArg()).project(Arrays.asList(projectionNode.getProjectionElemList()))) {
            projectionNode.replaceWith((QueryModelNode)pipelineNode);
        }
    }

    public void meet(MultiProjection projectionNode) throws Exception {
        AggregationPipelineQueryNode pipelineNode;
        projectionNode.visitChildren((QueryModelVisitor)this);
        if (projectionNode.getArg() instanceof AggregationPipelineQueryNode && projectionNode.getParentNode() != null && (pipelineNode = (AggregationPipelineQueryNode)projectionNode.getArg()).project(projectionNode.getProjections())) {
            projectionNode.replaceWith((QueryModelNode)pipelineNode);
        }
    }

    public void meet(Extension extensionNode) throws Exception {
        AggregationPipelineQueryNode pipelineNode;
        extensionNode.visitChildren((QueryModelVisitor)this);
        if (extensionNode.getArg() instanceof AggregationPipelineQueryNode && extensionNode.getParentNode() != null && (pipelineNode = (AggregationPipelineQueryNode)extensionNode.getArg()).extend(extensionNode.getElements())) {
            extensionNode.replaceWith((QueryModelNode)pipelineNode);
        }
    }

    public void meet(Reduced reducedNode) throws Exception {
        reducedNode.visitChildren((QueryModelVisitor)this);
        if (reducedNode.getArg() instanceof AggregationPipelineQueryNode && reducedNode.getParentNode() != null) {
            reducedNode.replaceWith((QueryModelNode)reducedNode.getArg());
        }
    }

    public void meet(Distinct distinctNode) throws Exception {
        distinctNode.visitChildren((QueryModelVisitor)this);
        if (distinctNode.getArg() instanceof AggregationPipelineQueryNode && distinctNode.getParentNode() != null) {
            AggregationPipelineQueryNode pipelineNode = (AggregationPipelineQueryNode)distinctNode.getArg();
            pipelineNode.distinct();
            distinctNode.replaceWith((QueryModelNode)pipelineNode);
        }
    }

    public void meet(Filter filterNode) throws Exception {
        AggregationPipelineQueryNode pipelineNode;
        filterNode.visitChildren((QueryModelVisitor)this);
        if (filterNode.getArg() instanceof AggregationPipelineQueryNode && filterNode.getParentNode() != null && (pipelineNode = (AggregationPipelineQueryNode)filterNode.getArg()).filter(filterNode.getCondition())) {
            filterNode.replaceWith((QueryModelNode)pipelineNode);
        }
    }
}

