/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.aggregation;

import com.google.common.base.Preconditions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCursor;
import java.util.Map;
import org.bson.Document;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class PipelineResultIteration
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private static final int BATCH_SIZE = 1000;
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final MongoCursor<Document> cursor;
    private final Map<String, String> varToOriginalName;
    private final BindingSet bindings;
    private BindingSet nextSolution = null;

    public PipelineResultIteration(AggregateIterable<Document> aggIter, Map<String, String> varToOriginalName, BindingSet bindings) {
        this.varToOriginalName = (Map)Preconditions.checkNotNull(varToOriginalName);
        this.bindings = (BindingSet)Preconditions.checkNotNull((Object)bindings);
        Preconditions.checkNotNull(aggIter);
        aggIter.batchSize(1000);
        this.cursor = aggIter.iterator();
    }

    private void lookahead() {
        while (this.nextSolution == null && this.cursor.hasNext()) {
            this.nextSolution = this.docToBindingSet((Document)this.cursor.next());
        }
    }

    public boolean hasNext() throws QueryEvaluationException {
        this.lookahead();
        return this.nextSolution != null;
    }

    public BindingSet next() throws QueryEvaluationException {
        this.lookahead();
        BindingSet solution = this.nextSolution;
        this.nextSolution = null;
        return solution;
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("remove() undefined for query result iteration");
    }

    public void close() throws QueryEvaluationException {
        this.cursor.close();
    }

    private QueryBindingSet docToBindingSet(Document result) {
        QueryBindingSet bindingSet = new QueryBindingSet(this.bindings);
        Document valueSet = (Document)result.get((Object)"<VALUES>", Document.class);
        Document typeSet = (Document)result.get((Object)"<TYPES>", Document.class);
        if (valueSet != null) {
            for (Map.Entry entry : valueSet.entrySet()) {
                String fieldName = (String)entry.getKey();
                String valueString = entry.getValue().toString();
                String typeString = typeSet == null ? null : typeSet.getString((Object)fieldName);
                String varName = this.varToOriginalName.getOrDefault(fieldName, fieldName);
                Object varValue = typeString == null || typeString.equals(XMLSchema.ANYURI.stringValue()) ? VF.createIRI(valueString) : VF.createLiteral(valueString, VF.createIRI(typeString));
                Binding existingBinding = bindingSet.getBinding(varName);
                if (existingBinding == null) {
                    bindingSet.addBinding(varName, (Value)varValue);
                    continue;
                }
                if (existingBinding.getValue().equals(varValue)) continue;
                return null;
            }
        }
        return bindingSet;
    }
}

