/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.aggregation;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.aggregation.SparqlToPipelineTransformVisitor;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationPipelineQueryOptimizer
implements QueryOptimizer,
Configurable {
    private StatefulMongoDBRdfConfiguration conf;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        SparqlToPipelineTransformVisitor pipelineVisitor = new SparqlToPipelineTransformVisitor(this.conf);
        try {
            tupleExpr.visit((QueryModelVisitor)pipelineVisitor);
        }
        catch (Exception e) {
            this.logger.error("Error attempting to transform query using the aggregation pipeline", (Throwable)e);
        }
    }

    public void setConf(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkArgument((boolean)(conf instanceof StatefulMongoDBRdfConfiguration), (String)"Expected an instance of %s; received %s", (Object[])new Object[]{StatefulMongoDBRdfConfiguration.class.getName(), conf.getClass().getName()});
        this.conf = (StatefulMongoDBRdfConfiguration)conf;
    }

    public StatefulMongoDBRdfConfiguration getConf() {
        return this.conf;
    }
}

