/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb.aggregation;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.StatementMetadata;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.mongodb.MongoDbRdfConstants;
import org.apache.rya.mongodb.aggregation.PipelineResultIteration;
import org.apache.rya.mongodb.dao.MongoDBStorageStrategy;
import org.apache.rya.mongodb.dao.SimpleMongoDBStorageStrategy;
import org.apache.rya.mongodb.document.operators.query.ConditionalOperators;
import org.apache.rya.mongodb.document.visibility.DocumentVisibilityAdapter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class AggregationPipelineQueryNode
extends ExternalSet {
    private static final long serialVersionUID = 1L;
    static final String VALUES = "<VALUES>";
    static final String HASHES = "<HASHES>";
    static final String TYPES = "<TYPES>";
    private static final String LEVEL = "derivation_level";
    private static final String[] FIELDS = new String[]{"<VALUES>", "<HASHES>", "<TYPES>", "derivation_level", "insertTimestamp"};
    private static final String JOINED_TRIPLE = "<JOINED_TRIPLE>";
    private static final String FIELDS_MATCH = "<JOIN_FIELDS_MATCH>";
    private static final MongoDBStorageStrategy<RyaStatement> strategy = new SimpleMongoDBStorageStrategy();
    private static final Bson DEFAULT_TYPE = new Document("$literal", (Object)XMLSchema.ANYURI.stringValue());
    private static final Bson DEFAULT_CONTEXT = new Document("$literal", (Object)"");
    private static final Bson DEFAULT_DV = DocumentVisibilityAdapter.toDocument(MongoDbRdfConstants.EMPTY_DV);
    private static final Bson DEFAULT_METADATA = new Document("$literal", (Object)StatementMetadata.EMPTY_METADATA.toString());
    private final List<Bson> pipeline;
    private final MongoCollection<Document> collection;
    private final Set<String> assuredBindingNames;
    private final Set<String> bindingNames;
    private final BiMap<String, String> varToOriginalName;

    private static boolean isValidFieldName(String name) {
        return name != null && !name.contains(".") && !name.contains("$") && !name.equals("_id");
    }

    private static Document getMatchExpression(StatementPattern sp, String ... path) {
        Var subjVar = sp.getSubjectVar();
        Var predVar = sp.getPredicateVar();
        Var objVar = sp.getObjectVar();
        Var contextVar = sp.getContextVar();
        RyaIRI s = null;
        RyaIRI p = null;
        RyaType o = null;
        RyaIRI c = null;
        if (subjVar != null && subjVar.getValue() instanceof Resource) {
            s = RdfToRyaConversions.convertResource((Resource)((Resource)subjVar.getValue()));
        }
        if (predVar != null && predVar.getValue() instanceof IRI) {
            p = RdfToRyaConversions.convertIRI((IRI)((IRI)predVar.getValue()));
        }
        if (objVar != null && objVar.getValue() != null) {
            o = RdfToRyaConversions.convertValue((Value)objVar.getValue());
        }
        if (contextVar != null && contextVar.getValue() instanceof IRI) {
            c = RdfToRyaConversions.convertIRI((IRI)((IRI)contextVar.getValue()));
        }
        RyaStatement rs = new RyaStatement(s, p, o, c);
        Document obj = strategy.getQuery(rs);
        if (path.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String str : path) {
                sb.append(str).append(".");
            }
            String prefix = sb.toString();
            HashSet originalKeys = new HashSet(obj.keySet());
            originalKeys.forEach(key -> {
                Object value = obj.remove(key);
                obj.put(prefix + key, value);
            });
        }
        return obj;
    }

    private static String valueFieldExpr(String varName) {
        return "$<VALUES>." + varName;
    }

    private static String hashFieldExpr(String varName) {
        return "$<HASHES>." + varName;
    }

    private static String typeFieldExpr(String varName) {
        return "$<TYPES>." + varName;
    }

    private static String joinFieldExpr(String triplePart) {
        return "$<JOINED_TRIPLE>." + triplePart;
    }

    private Object valueFieldExpr(ValueExpr expr) {
        if (expr instanceof Var) {
            return AggregationPipelineQueryNode.valueFieldExpr(((Var)expr).getName());
        }
        if (expr instanceof ValueConstant) {
            return new Document("$literal", (Object)((ValueConstant)expr).getValue().stringValue());
        }
        return null;
    }

    private String replace(String original) {
        if (this.varToOriginalName.containsValue((Object)original)) {
            return (String)this.varToOriginalName.inverse().get((Object)original);
        }
        String replacement = "field-" + UUID.randomUUID();
        this.varToOriginalName.put((Object)replacement, (Object)original);
        return replacement;
    }

    public AggregationPipelineQueryNode(MongoCollection<Document> collection, StatementPattern baseSP) {
        this.collection = (MongoCollection)Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull((Object)baseSP);
        this.varToOriginalName = HashBiMap.create();
        StatementVarMapping mapping = new StatementVarMapping(baseSP, this.varToOriginalName);
        this.assuredBindingNames = new HashSet<String>(mapping.varNames());
        this.bindingNames = new HashSet<String>(mapping.varNames());
        this.pipeline = new LinkedList<Bson>();
        this.pipeline.add(Aggregates.match((Bson)AggregationPipelineQueryNode.getMatchExpression(baseSP, new String[0])));
        this.pipeline.add(Aggregates.project((Bson)mapping.getProjectExpression()));
    }

    AggregationPipelineQueryNode(MongoCollection<Document> collection, List<Bson> pipeline, Set<String> assuredBindingNames, Set<String> bindingNames, BiMap<String, String> varToOriginalName) {
        this.collection = (MongoCollection)Preconditions.checkNotNull(collection);
        this.pipeline = (List)Preconditions.checkNotNull(pipeline);
        this.assuredBindingNames = (Set)Preconditions.checkNotNull(assuredBindingNames);
        this.bindingNames = (Set)Preconditions.checkNotNull(bindingNames);
        this.varToOriginalName = (BiMap)Preconditions.checkNotNull(varToOriginalName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AggregationPipelineQueryNode) {
            AggregationPipelineQueryNode other = (AggregationPipelineQueryNode)((Object)o);
            if (this.collection.equals(other.collection) && this.assuredBindingNames.equals(other.assuredBindingNames) && this.bindingNames.equals(other.bindingNames) && this.varToOriginalName.equals(other.varToOriginalName) && this.pipeline.size() == other.pipeline.size()) {
                for (int i = 0; i < this.pipeline.size(); ++i) {
                    Bson doc1 = this.pipeline.get(i);
                    Bson doc2 = other.pipeline.get(i);
                    if (doc1.toString().equals(doc2.toString())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.collection, this.pipeline, this.assuredBindingNames, this.bindingNames, this.varToOriginalName});
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        return new PipelineResultIteration((AggregateIterable<Document>)this.collection.aggregate(this.pipeline), (Map<String, String>)this.varToOriginalName, bindings);
    }

    public Set<String> getAssuredBindingNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.assuredBindingNames) {
            names.add((String)this.varToOriginalName.getOrDefault((Object)name, (Object)name));
        }
        return names;
    }

    public Set<String> getBindingNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.bindingNames) {
            names.add((String)this.varToOriginalName.getOrDefault((Object)name, (Object)name));
        }
        return names;
    }

    public AggregationPipelineQueryNode clone() {
        return new AggregationPipelineQueryNode(this.collection, new LinkedList<Bson>(this.pipeline), new HashSet<String>(this.assuredBindingNames), new HashSet<String>(this.bindingNames), (BiMap<String, String>)HashBiMap.create(this.varToOriginalName));
    }

    public String getSignature() {
        super.getSignature();
        Set<String> assured = this.getAssuredBindingNames();
        Set<String> any = this.getBindingNames();
        StringBuilder sb = new StringBuilder("AggregationPipelineQueryNode (binds: ");
        sb.append(String.join((CharSequence)", ", assured));
        if (any.size() > assured.size()) {
            Set<String> optionalBindingNames = any;
            optionalBindingNames.removeAll(assured);
            sb.append(" [").append(String.join((CharSequence)", ", optionalBindingNames)).append("]");
        }
        sb.append(")\n");
        for (Bson doc : this.pipeline) {
            sb.append(doc.toString()).append("\n");
        }
        return sb.toString();
    }

    List<Bson> getPipeline() {
        return this.pipeline;
    }

    public boolean joinWith(StatementPattern sp) {
        Preconditions.checkNotNull((Object)sp);
        StatementVarMapping spMap = new StatementVarMapping(sp, this.varToOriginalName);
        ConcurrentSkipListSet<String> sharedVars = new ConcurrentSkipListSet<String>(spMap.varNames());
        sharedVars.retainAll(this.assuredBindingNames);
        String joinKey = (String)sharedVars.pollFirst();
        String collectionName = this.collection.getNamespace().getCollectionName();
        if (joinKey == null) {
            return false;
        }
        Bson join = Aggregates.lookup((String)collectionName, (String)("<HASHES>." + joinKey), (String)spMap.hashField(joinKey), (String)JOINED_TRIPLE);
        this.pipeline.add(join);
        this.pipeline.add(Aggregates.unwind((String)"$<JOINED_TRIPLE>"));
        Document matchOpts = AggregationPipelineQueryNode.getMatchExpression(sp, JOINED_TRIPLE);
        if (!sharedVars.isEmpty()) {
            LinkedList<Document> eqTests = new LinkedList<Document>();
            for (String varName : sharedVars) {
                String oldField = AggregationPipelineQueryNode.valueFieldExpr(varName);
                String newField = AggregationPipelineQueryNode.joinFieldExpr(spMap.valueField(varName));
                Document eqTest = new Document("$eq", Arrays.asList(oldField, newField));
                eqTests.add(eqTest);
            }
            Bson eqProjectOpts = Projections.fields((Bson[])new Bson[]{Projections.computed((String)FIELDS_MATCH, (Object)Filters.and(eqTests)), Projections.include((String[])new String[]{JOINED_TRIPLE, VALUES, HASHES, TYPES, LEVEL, "insertTimestamp"})});
            this.pipeline.add(Aggregates.project((Bson)eqProjectOpts));
            matchOpts.put(FIELDS_MATCH, (Object)true);
        }
        this.pipeline.add(Aggregates.match((Bson)matchOpts));
        Bson finalProjectOpts = new StatementVarMapping(sp, this.varToOriginalName).getProjectExpression(this.assuredBindingNames, str -> AggregationPipelineQueryNode.joinFieldExpr(str));
        this.assuredBindingNames.addAll(spMap.varNames());
        this.bindingNames.addAll(spMap.varNames());
        this.pipeline.add(Aggregates.project((Bson)finalProjectOpts));
        return true;
    }

    public boolean project(Iterable<ProjectionElemList> projections) {
        if (projections == null || !projections.iterator().hasNext()) {
            return false;
        }
        LinkedList<Document> projectOpts = new LinkedList<Document>();
        HashSet bindingNamesUnion = new HashSet();
        HashSet bindingNamesIntersection = null;
        for (ProjectionElemList projection : projections) {
            if (projection.getElements().isEmpty()) {
                return false;
            }
            Document valueDoc = new Document();
            Document hashDoc = new Document();
            Document typeDoc = new Document();
            HashSet<String> projectionBindingNames = new HashSet<String>();
            for (ProjectionElem elem : projection.getElements()) {
                String from;
                String to = elem.getTargetName();
                if (!AggregationPipelineQueryNode.isValidFieldName(to)) {
                    to = this.replace(to);
                }
                if (this.varToOriginalName.containsValue((Object)(from = elem.getSourceName()))) {
                    from = (String)this.varToOriginalName.inverse().get((Object)from);
                }
                projectionBindingNames.add(to);
                if (to.equals(from)) {
                    valueDoc.append(to, (Object)1);
                    hashDoc.append(to, (Object)1);
                    typeDoc.append(to, (Object)1);
                    continue;
                }
                valueDoc.append(to, (Object)AggregationPipelineQueryNode.valueFieldExpr(from));
                hashDoc.append(to, (Object)AggregationPipelineQueryNode.hashFieldExpr(from));
                typeDoc.append(to, (Object)AggregationPipelineQueryNode.typeFieldExpr(from));
            }
            bindingNamesUnion.addAll(projectionBindingNames);
            if (bindingNamesIntersection == null) {
                bindingNamesIntersection = new HashSet(projectionBindingNames);
            } else {
                bindingNamesIntersection.retainAll(projectionBindingNames);
            }
            projectOpts.add(new Document().append(VALUES, (Object)valueDoc).append(HASHES, (Object)hashDoc).append(TYPES, (Object)typeDoc).append(LEVEL, (Object)"$derivation_level").append("insertTimestamp", (Object)"$insertTimestamp"));
        }
        if (projectOpts.size() == 1) {
            this.pipeline.add(Aggregates.project((Bson)((Bson)projectOpts.get(0))));
        } else {
            String listKey = "PROJECTIONS";
            Bson projectIndividual = Projections.fields((Bson[])new Bson[]{Projections.computed((String)VALUES, (Object)"$PROJECTIONS.<VALUES>"), Projections.computed((String)HASHES, (Object)"$PROJECTIONS.<HASHES>"), Projections.computed((String)TYPES, (Object)"$PROJECTIONS.<TYPES>"), Projections.include((String[])new String[]{LEVEL}), Projections.include((String[])new String[]{"insertTimestamp"})});
            this.pipeline.add(Aggregates.project((Bson)Projections.computed((String)"PROJECTIONS", projectOpts)));
            this.pipeline.add(Aggregates.unwind((String)"$PROJECTIONS"));
            this.pipeline.add(Aggregates.project((Bson)projectIndividual));
        }
        this.assuredBindingNames.clear();
        this.bindingNames.clear();
        this.assuredBindingNames.addAll(bindingNamesIntersection);
        this.bindingNames.addAll(bindingNamesUnion);
        return true;
    }

    public boolean extend(Iterable<ExtensionElem> extensionElements) {
        LinkedList<Bson> valueFields = new LinkedList<Bson>();
        LinkedList<Bson> hashFields = new LinkedList<Bson>();
        LinkedList<Bson> typeFields = new LinkedList<Bson>();
        for (String string : this.bindingNames) {
            valueFields.add(Projections.include((String[])new String[]{string}));
            hashFields.add(Projections.include((String[])new String[]{string}));
            typeFields.add(Projections.include((String[])new String[]{string}));
        }
        HashSet<String> newVarNames = new HashSet<String>();
        for (ExtensionElem elem : extensionElements) {
            String typeField;
            String hashField;
            String valueField;
            ValueExpr expr;
            String name = elem.getName();
            if (!AggregationPipelineQueryNode.isValidFieldName(name)) {
                name = this.replace(name);
            }
            if ((expr = elem.getExpr()) instanceof Var) {
                String varName = ((Var)expr).getName();
                valueField = "$" + varName;
                hashField = "$" + varName;
                typeField = "$" + varName;
            } else if (expr instanceof ValueConstant) {
                Value val = ((ValueConstant)expr).getValue();
                valueField = new Document("$literal", (Object)val.stringValue());
                hashField = new Document("$literal", (Object)SimpleMongoDBStorageStrategy.hash(val.stringValue()));
                typeField = val instanceof Literal ? new Document("$literal", (Object)((Literal)val).getDatatype().stringValue()) : null;
            } else {
                return false;
            }
            valueFields.add(Projections.computed((String)name, (Object)valueField));
            hashFields.add(Projections.computed((String)name, (Object)hashField));
            if (typeField != null) {
                typeFields.add(Projections.computed((String)name, (Object)typeField));
            }
            newVarNames.add(name);
        }
        this.assuredBindingNames.addAll(newVarNames);
        this.bindingNames.addAll(newVarNames);
        Bson bson = Projections.fields((Bson[])new Bson[]{Projections.computed((String)VALUES, (Object)Projections.fields(valueFields)), Projections.computed((String)HASHES, (Object)Projections.fields(hashFields)), Projections.computed((String)TYPES, (Object)Projections.fields(typeFields)), Projections.include((String[])new String[]{LEVEL}), Projections.include((String[])new String[]{"insertTimestamp"})});
        this.pipeline.add(Aggregates.project((Bson)bson));
        return true;
    }

    public boolean filter(ValueExpr condition) {
        if (condition instanceof Compare) {
            String opFunc;
            Compare compare = (Compare)condition;
            Compare.CompareOp operator = compare.getOperator();
            Object leftArg = this.valueFieldExpr(compare.getLeftArg());
            Object rightArg = this.valueFieldExpr(compare.getRightArg());
            if (leftArg == null || rightArg == null) {
                return false;
            }
            switch (operator) {
                case EQ: {
                    opFunc = "$eq";
                    break;
                }
                case NE: {
                    opFunc = "$ne";
                    break;
                }
                case LT: {
                    opFunc = "$lt";
                    break;
                }
                case LE: {
                    opFunc = "$le";
                    break;
                }
                case GT: {
                    opFunc = "$gt";
                    break;
                }
                case GE: {
                    opFunc = "$ge";
                    break;
                }
                default: {
                    return false;
                }
            }
            Document compareDoc = new Document(opFunc, Arrays.asList(leftArg, rightArg));
            this.pipeline.add(Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.computed((String)"FILTER", (Object)compareDoc), Projections.include((String[])new String[]{VALUES, HASHES, TYPES, LEVEL, "insertTimestamp"})})));
            this.pipeline.add(Aggregates.match((Bson)new Document("FILTER", (Object)true)));
            this.pipeline.add(Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{VALUES, HASHES, TYPES, LEVEL, "insertTimestamp"})})));
            return true;
        }
        return false;
    }

    public boolean distinct() {
        LinkedList<String> key = new LinkedList<String>();
        for (String varName : this.bindingNames) {
            key.add(AggregationPipelineQueryNode.hashFieldExpr(varName));
        }
        LinkedList<BsonField> reduceOps = new LinkedList<BsonField>();
        for (String field : FIELDS) {
            reduceOps.add(new BsonField(field, (Bson)new Document("$first", (Object)("$" + field))));
        }
        this.pipeline.add(Aggregates.group((Object)new Document("$concat", key), reduceOps));
        return true;
    }

    public void requireSourceDerivationDepth(int requiredLevel) {
        if (requiredLevel > 0) {
            this.pipeline.add(Aggregates.match((Bson)Filters.gte((String)LEVEL, (Object)requiredLevel)));
        }
    }

    public void requireSourceTimestamp(long t) {
        this.pipeline.add(Aggregates.match((Bson)Filters.gte((String)"insertTimestamp", (Object)t)));
    }

    public List<Bson> getTriplePipeline(long timestamp, boolean requireNew) {
        if (!(this.assuredBindingNames.contains("subject") && this.assuredBindingNames.contains("predicate") && this.assuredBindingNames.contains("object"))) {
            throw new IllegalStateException("Current pipeline does not produce records that can be converted into triples.\nRequired variable names: <subject, predicate, object>\nCurrent variable names: " + this.assuredBindingNames);
        }
        LinkedList<Bson> triplePipeline = new LinkedList<Bson>(this.pipeline);
        LinkedList<Bson> fields = new LinkedList<Bson>();
        fields.add(Projections.computed((String)"subject", (Object)AggregationPipelineQueryNode.valueFieldExpr("subject")));
        fields.add(Projections.computed((String)"subject_hash", (Object)AggregationPipelineQueryNode.hashFieldExpr("subject")));
        fields.add(Projections.computed((String)"predicate", (Object)AggregationPipelineQueryNode.valueFieldExpr("predicate")));
        fields.add(Projections.computed((String)"predicate_hash", (Object)AggregationPipelineQueryNode.hashFieldExpr("predicate")));
        fields.add(Projections.computed((String)"object", (Object)AggregationPipelineQueryNode.valueFieldExpr("object")));
        fields.add(Projections.computed((String)"object_hash", (Object)AggregationPipelineQueryNode.hashFieldExpr("object")));
        fields.add(Projections.computed((String)"objectType", (Object)ConditionalOperators.ifNull(AggregationPipelineQueryNode.typeFieldExpr("object"), DEFAULT_TYPE)));
        fields.add(Projections.computed((String)"context", (Object)DEFAULT_CONTEXT));
        fields.add(Projections.computed((String)"statementMetadata", (Object)DEFAULT_METADATA));
        fields.add(DEFAULT_DV);
        fields.add(Projections.computed((String)"insertTimestamp", (Object)new Document("$literal", (Object)timestamp)));
        fields.add(Projections.computed((String)LEVEL, (Object)new Document("$add", Arrays.asList("$derivation_level", 1))));
        triplePipeline.add(Aggregates.project((Bson)Projections.fields(fields)));
        if (requireNew) {
            String collectionName = this.collection.getNamespace().getCollectionName();
            Bson includeAll = Projections.include((String[])new String[]{"subject", "subject_hash", "predicate", "predicate_hash", "object", "object_hash", "objectType", "context", "statementMetadata", "documentVisibility", "insertTimestamp", LEVEL});
            LinkedList<Document> eqTests = new LinkedList<Document>();
            eqTests.add(new Document("$eq", Arrays.asList("$$this.predicate_hash", "$predicate_hash")));
            eqTests.add(new Document("$eq", Arrays.asList("$$this.object_hash", "$object_hash")));
            Document redundantFilter = new Document("$filter", (Object)new Document("input", (Object)"$<JOINED_TRIPLE>").append("as", (Object)"this").append("cond", (Object)new Document("$and", eqTests)));
            triplePipeline.add(Aggregates.lookup((String)collectionName, (String)"subject_hash", (String)"subject_hash", (String)JOINED_TRIPLE));
            String numRedundant = "REDUNDANT";
            triplePipeline.add(Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{includeAll, Projections.computed((String)"REDUNDANT", (Object)new Document("$size", (Object)redundantFilter))})));
            triplePipeline.add(Aggregates.match((Bson)Filters.eq((String)"REDUNDANT", (Object)0)));
            triplePipeline.add(Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{includeAll})));
        }
        return triplePipeline;
    }

    private static class StatementVarMapping {
        private final Map<String, String> varToTripleValue = new HashMap<String, String>();
        private final Map<String, String> varToTripleHash = new HashMap<String, String>();
        private final Map<String, String> varToTripleType = new HashMap<String, String>();
        private final BiMap<String, String> varToOriginalName;

        String valueField(String varName) {
            return this.varToTripleValue.get(varName);
        }

        String hashField(String varName) {
            return this.varToTripleHash.get(varName);
        }

        String typeField(String varName) {
            return this.varToTripleType.get(varName);
        }

        Set<String> varNames() {
            return this.varToTripleValue.keySet();
        }

        private String replace(String original) {
            if (this.varToOriginalName.containsValue((Object)original)) {
                return (String)this.varToOriginalName.inverse().get((Object)original);
            }
            String replacement = "field-" + UUID.randomUUID();
            this.varToOriginalName.put((Object)replacement, (Object)original);
            return replacement;
        }

        private String sanitize(String name) {
            if (this.varToOriginalName.containsValue((Object)name)) {
                return (String)this.varToOriginalName.inverse().get((Object)name);
            }
            if (name != null && !AggregationPipelineQueryNode.isValidFieldName(name)) {
                return this.replace(name);
            }
            return name;
        }

        StatementVarMapping(StatementPattern sp, BiMap<String, String> varToOriginalName) {
            String name;
            this.varToOriginalName = varToOriginalName;
            if (sp.getSubjectVar() != null && !sp.getSubjectVar().hasValue()) {
                name = this.sanitize(sp.getSubjectVar().getName());
                this.varToTripleValue.put(name, "subject");
                this.varToTripleHash.put(name, "subject_hash");
            }
            if (sp.getPredicateVar() != null && !sp.getPredicateVar().hasValue()) {
                name = this.sanitize(sp.getPredicateVar().getName());
                this.varToTripleValue.put(name, "predicate");
                this.varToTripleHash.put(name, "predicate_hash");
            }
            if (sp.getObjectVar() != null && !sp.getObjectVar().hasValue()) {
                name = this.sanitize(sp.getObjectVar().getName());
                this.varToTripleValue.put(name, "object");
                this.varToTripleHash.put(name, "object_hash");
                this.varToTripleType.put(name, "objectType");
            }
            if (sp.getContextVar() != null && !sp.getContextVar().hasValue()) {
                name = this.sanitize(sp.getContextVar().getName());
                this.varToTripleValue.put(name, "context");
            }
        }

        Bson getProjectExpression() {
            return this.getProjectExpression(new LinkedList<String>(), str -> "$" + str);
        }

        Bson getProjectExpression(Iterable<String> alsoInclude, Function<String, String> getFieldExpr) {
            Document values = new Document();
            Document hashes = new Document();
            Document types = new Document();
            for (String varName : this.varNames()) {
                values.append(varName, (Object)getFieldExpr.apply(this.valueField(varName)));
                if (this.varToTripleHash.containsKey(varName)) {
                    hashes.append(varName, (Object)getFieldExpr.apply(this.hashField(varName)));
                }
                if (!this.varToTripleType.containsKey(varName)) continue;
                types.append(varName, (Object)getFieldExpr.apply(this.typeField(varName)));
            }
            for (String varName : alsoInclude) {
                values.append(varName, (Object)1);
                hashes.append(varName, (Object)1);
                types.append(varName, (Object)1);
            }
            LinkedList<Bson> fields = new LinkedList<Bson>();
            fields.add(Projections.excludeId());
            if (!values.isEmpty()) {
                fields.add(Projections.computed((String)AggregationPipelineQueryNode.VALUES, (Object)values));
            }
            if (!hashes.isEmpty()) {
                fields.add(Projections.computed((String)AggregationPipelineQueryNode.HASHES, (Object)hashes));
            }
            if (!types.isEmpty()) {
                fields.add(Projections.computed((String)AggregationPipelineQueryNode.TYPES, (Object)types));
            }
            fields.add(Projections.computed((String)AggregationPipelineQueryNode.LEVEL, (Object)new Document("$max", Arrays.asList("$derivation_level", (Serializable)((Object)getFieldExpr.apply(AggregationPipelineQueryNode.LEVEL)), 0))));
            fields.add(Projections.computed((String)"insertTimestamp", (Object)new Document("$max", Arrays.asList("$insertTimestamp", (Serializable)((Object)getFieldExpr.apply("insertTimestamp")), 0))));
            return Projections.fields(fields);
        }
    }
}

