/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb;

import com.mongodb.MongoClient;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;
import org.apache.rya.mongodb.MongoSecondaryIndex;

@DefaultAnnotation(value={NonNull.class})
public class StatefulMongoDBRdfConfiguration
extends MongoDBRdfConfiguration {
    private final MongoClient mongoClient;
    private List<MongoSecondaryIndex> indexers;

    public StatefulMongoDBRdfConfiguration(Configuration other, MongoClient mongoClient, List<MongoSecondaryIndex> indexers) {
        super(other);
        this.mongoClient = Objects.requireNonNull(mongoClient);
        this.indexers = Objects.requireNonNull(indexers);
    }

    public StatefulMongoDBRdfConfiguration(Configuration other, MongoClient mongoClient) {
        this(other, mongoClient, new ArrayList<MongoSecondaryIndex>());
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setIndexers(List<MongoSecondaryIndex> indexers) {
        this.indexers = Objects.requireNonNull(indexers);
    }

    public List<MongoSecondaryIndex> getAdditionalIndexers() {
        return this.indexers;
    }

    @Override
    public MongoDBRdfConfiguration clone() {
        return new StatefulMongoDBRdfConfiguration((Configuration)this, this.mongoClient, this.indexers);
    }
}

