/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAO;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.persist.RyaNamespaceManager;
import org.apache.rya.api.persist.index.RyaSecondaryIndexer;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.mongodb.MongoDBQueryEngine;
import org.apache.rya.mongodb.MongoSecondaryIndex;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.batch.MongoDbBatchWriter;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterConfig;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterException;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterUtils;
import org.apache.rya.mongodb.batch.collection.MongoCollectionType;
import org.apache.rya.mongodb.dao.MongoDBNamespaceManager;
import org.apache.rya.mongodb.dao.MongoDBStorageStrategy;
import org.apache.rya.mongodb.dao.SimpleMongoDBNamespaceManager;
import org.apache.rya.mongodb.dao.SimpleMongoDBStorageStrategy;
import org.apache.rya.mongodb.document.util.DocumentVisibilityUtil;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class MongoDBRyaDAO
implements RyaDAO<StatefulMongoDBRdfConfiguration> {
    private static final Logger log = Logger.getLogger(MongoDBRyaDAO.class);
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private final AtomicBoolean flushEachUpdate = new AtomicBoolean(true);
    private StatefulMongoDBRdfConfiguration conf;
    private MongoClient mongoClient;
    private MongoDatabase db;
    private MongoCollection<Document> coll;
    private MongoDBQueryEngine queryEngine;
    private MongoDBStorageStrategy<RyaStatement> storageStrategy;
    private MongoDBNamespaceManager nameSpaceManager;
    private List<MongoSecondaryIndex> secondaryIndexers;
    private Authorizations auths;
    private MongoDbBatchWriter<Document> mongoDbBatchWriter;

    public synchronized void setConf(StatefulMongoDBRdfConfiguration conf) {
        this.conf = Objects.requireNonNull(conf);
        this.mongoClient = this.conf.getMongoClient();
        this.auths = conf.getAuthorizations();
        this.flushEachUpdate.set(conf.flushEachUpdate());
    }

    public void setDB(MongoDatabase db) {
        this.db = db;
    }

    public void setDBCollection(MongoCollection<Document> coll) {
        this.coll = coll;
    }

    public synchronized StatefulMongoDBRdfConfiguration getConf() {
        return this.conf;
    }

    public void init() throws RyaDAOException {
        if (this.isInitialized.get()) {
            return;
        }
        this.secondaryIndexers = this.conf.getAdditionalIndexers();
        for (MongoSecondaryIndex index : this.secondaryIndexers) {
            index.setConf((Configuration)this.conf);
        }
        this.db = this.mongoClient.getDatabase(this.conf.get("mongo.db.name"));
        this.coll = this.db.getCollection(this.conf.getTriplesCollectionName());
        this.nameSpaceManager = new SimpleMongoDBNamespaceManager((MongoCollection<Document>)this.db.getCollection(this.conf.getNameSpacesCollectionName()));
        this.queryEngine = new MongoDBQueryEngine();
        this.queryEngine.setConf(this.conf);
        this.storageStrategy = new SimpleMongoDBStorageStrategy();
        this.storageStrategy.createIndices(this.coll);
        for (MongoSecondaryIndex index : this.secondaryIndexers) {
            index.init();
        }
        MongoDbBatchWriterConfig mongoDbBatchWriterConfig = MongoDbBatchWriterUtils.getMongoDbBatchWriterConfig((Configuration)this.conf);
        this.mongoDbBatchWriter = new MongoDbBatchWriter<Document>(new MongoCollectionType(this.coll), mongoDbBatchWriterConfig);
        try {
            this.mongoDbBatchWriter.start();
        }
        catch (MongoDbBatchWriterException e) {
            throw new RyaDAOException("Error starting MongoDB batch writer", (Throwable)e);
        }
        this.isInitialized.set(true);
    }

    public boolean isInitialized() throws RyaDAOException {
        return this.isInitialized.get();
    }

    public void destroy() throws RyaDAOException {
        if (!this.isInitialized.get()) {
            return;
        }
        this.isInitialized.set(false);
        this.flush();
        try {
            this.mongoDbBatchWriter.shutdown();
        }
        catch (MongoDbBatchWriterException e) {
            throw new RyaDAOException("Error shutting down MongoDB batch writer", (Throwable)e);
        }
        for (MongoSecondaryIndex indexer : this.secondaryIndexers) {
            try {
                indexer.close();
            }
            catch (IOException e) {
                log.error((Object)("Error closing indexer: " + indexer.getClass().getSimpleName()), (Throwable)e);
            }
        }
        IOUtils.closeQuietly((Closeable)((Object)this.queryEngine));
    }

    public void add(RyaStatement statement) throws RyaDAOException {
        block8: {
            try {
                boolean canAdd = DocumentVisibilityUtil.doesUserHaveDocumentAccess(this.auths, statement.getColumnVisibility());
                if (canAdd) {
                    Document obj = this.storageStrategy.serialize(statement);
                    try {
                        this.mongoDbBatchWriter.addObjectToQueue(obj);
                        if (this.flushEachUpdate.get()) {
                            this.flush();
                        }
                    }
                    catch (MongoDbBatchWriterException e) {
                        throw new RyaDAOException("Error adding statement", (Throwable)e);
                    }
                    for (RyaSecondaryIndexer ryaSecondaryIndexer : this.secondaryIndexers) {
                        ryaSecondaryIndexer.storeStatement(statement);
                    }
                    break block8;
                }
                throw new RyaDAOException("User does not have the required authorizations to add statement");
            }
            catch (IOException e) {
                log.error((Object)("Unable to add: " + statement.toString()));
                throw new RyaDAOException((Throwable)e);
            }
            catch (DuplicateKeyException e) {
                log.error((Object)("Attempting to load duplicate triple: " + statement.toString()));
            }
        }
    }

    public void add(Iterator<RyaStatement> statementIter) throws RyaDAOException {
        ArrayList<Document> dbInserts = new ArrayList<Document>();
        while (statementIter.hasNext()) {
            RyaStatement ryaStatement = statementIter.next();
            boolean canAdd = DocumentVisibilityUtil.doesUserHaveDocumentAccess(this.auths, ryaStatement.getColumnVisibility());
            if (canAdd) {
                Document insert = this.storageStrategy.serialize(ryaStatement);
                dbInserts.add(insert);
                try {
                    for (RyaSecondaryIndexer ryaSecondaryIndexer : this.secondaryIndexers) {
                        ryaSecondaryIndexer.storeStatement(ryaStatement);
                    }
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)("Failed to add: " + ryaStatement.toString() + " to the indexer"));
                    continue;
                }
            }
            throw new RyaDAOException("User does not have the required authorizations to add statement");
        }
        try {
            this.mongoDbBatchWriter.addObjectsToQueue(dbInserts);
            if (this.flushEachUpdate.get()) {
                this.flush();
            }
        }
        catch (MongoDbBatchWriterException e) {
            throw new RyaDAOException("Error adding statements", (Throwable)e);
        }
    }

    public void delete(RyaStatement statement, StatefulMongoDBRdfConfiguration conf) throws RyaDAOException {
        boolean canDelete = DocumentVisibilityUtil.doesUserHaveDocumentAccess(this.auths, statement.getColumnVisibility());
        if (canDelete) {
            Document obj = this.storageStrategy.getQuery(statement);
            this.coll.deleteOne((Bson)obj);
            for (RyaSecondaryIndexer ryaSecondaryIndexer : this.secondaryIndexers) {
                try {
                    ryaSecondaryIndexer.deleteStatement(statement);
                }
                catch (IOException e) {
                    log.error((Object)("Unable to remove statement: " + statement.toString() + " from secondary indexer: " + ryaSecondaryIndexer.getTableName()), (Throwable)e);
                }
            }
        } else {
            throw new RyaDAOException("User does not have the required authorizations to delete statement");
        }
    }

    public void dropGraph(StatefulMongoDBRdfConfiguration conf, RyaIRI ... graphs) throws RyaDAOException {
    }

    public void delete(Iterator<RyaStatement> statements, StatefulMongoDBRdfConfiguration conf) throws RyaDAOException {
        while (statements.hasNext()) {
            RyaStatement ryaStatement = statements.next();
            boolean canDelete = DocumentVisibilityUtil.doesUserHaveDocumentAccess(this.auths, ryaStatement.getColumnVisibility());
            if (canDelete) {
                Document obj = this.storageStrategy.getQuery(ryaStatement);
                this.coll.deleteOne((Bson)obj);
                for (RyaSecondaryIndexer ryaSecondaryIndexer : this.secondaryIndexers) {
                    try {
                        ryaSecondaryIndexer.deleteStatement(ryaStatement);
                    }
                    catch (IOException e) {
                        log.error((Object)("Unable to remove statement: " + ryaStatement.toString() + " from secondary indexer: " + ryaSecondaryIndexer.getTableName()), (Throwable)e);
                    }
                }
                continue;
            }
            throw new RyaDAOException("User does not have the required authorizations to delete statement");
        }
    }

    public String getVersion() throws RyaDAOException {
        return "1.0";
    }

    public RyaQueryEngine<StatefulMongoDBRdfConfiguration> getQueryEngine() {
        return this.queryEngine;
    }

    public RyaNamespaceManager<StatefulMongoDBRdfConfiguration> getNamespaceManager() {
        return this.nameSpaceManager;
    }

    public void purge(RdfCloudTripleStoreConfiguration configuration) {
    }

    public void dropAndDestroy() throws RyaDAOException {
        this.db.drop();
    }

    public void flush() throws RyaDAOException {
        try {
            this.mongoDbBatchWriter.flush();
            this.flushIndexers();
        }
        catch (MongoDbBatchWriterException e) {
            throw new RyaDAOException("Error flushing data.", (Throwable)e);
        }
    }

    private void flushIndexers() throws RyaDAOException {
        for (MongoSecondaryIndex indexer : this.secondaryIndexers) {
            try {
                indexer.flush();
            }
            catch (IOException e) {
                log.error((Object)("Error flushing data in indexer: " + indexer.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }
}

