/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.mongodb.MongoDBRdfConfigurationBuilder;
import org.apache.rya.mongodb.MongoDbRdfConstants;
import org.apache.rya.mongodb.aggregation.AggregationPipelineQueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;

public class MongoDBRdfConfiguration
extends RdfCloudTripleStoreConfiguration {
    public static final String MONGO_HOSTNAME = "mongo.db.instance";
    public static final String MONGO_PORT = "mongo.db.port";
    public static final String MONGO_DB_NAME = "mongo.db.name";
    public static final String MONGO_USER = "mongo.db.user";
    public static final String MONGO_USER_PASSWORD = "mongo.db.userpassword";
    public static final String MONGO_COLLECTION_PREFIX = "mongo.db.collectionprefix";
    public static final String USE_MOCK_MONGO = ".useMockInstance";
    public static final String CONF_FLUSH_EACH_UPDATE = "rya.mongodb.dao.flusheachupdate";
    public static final String CONF_ADDITIONAL_INDEXERS = "ac.additional.indexers";
    public static final String MONGO_GEO_MAXDISTANCE = "mongo.geo.maxdist";
    public static final String USE_AGGREGATION_PIPELINE = "rya.mongodb.query.pipeline";

    public MongoDBRdfConfiguration() {
    }

    public MongoDBRdfConfiguration(Configuration other) {
        super(Objects.requireNonNull(other));
    }

    public static MongoDBRdfConfiguration fromProperties(Properties props) {
        Objects.requireNonNull(props);
        return MongoDBRdfConfigurationBuilder.fromProperties(props);
    }

    public static MongoDBRdfConfigurationBuilder getBuilder() {
        return new MongoDBRdfConfigurationBuilder();
    }

    public MongoDBRdfConfiguration clone() {
        return new MongoDBRdfConfiguration((Configuration)this);
    }

    public void setUseMock(boolean useMock) {
        this.setBoolean(USE_MOCK_MONGO, useMock);
    }

    public boolean getUseMock() {
        return this.getBoolean(USE_MOCK_MONGO, false);
    }

    public String getMongoHostname() {
        return this.get(MONGO_HOSTNAME, "localhost");
    }

    public void setMongoHostname(String hostname) {
        Objects.requireNonNull(hostname);
        this.set(MONGO_HOSTNAME, hostname);
    }

    public String getMongoPort() {
        return this.get(MONGO_PORT, "27017");
    }

    public void setMongoPort(String port) {
        Objects.requireNonNull(port);
        this.set(MONGO_PORT, port);
    }

    public String getMongoDBName() {
        return this.get(MONGO_DB_NAME, "rya");
    }

    public void setMongoDBName(String database) {
        Objects.requireNonNull(database);
        this.set(MONGO_DB_NAME, database);
    }

    public void setMongoUser(String user) {
        Objects.requireNonNull(user);
        this.set(MONGO_USER, user);
    }

    @Nullable
    public String getMongoUser() {
        return this.get(MONGO_USER);
    }

    public void setMongoPassword(String password) {
        Objects.requireNonNull(password);
        this.set(MONGO_USER_PASSWORD, password);
    }

    @Nullable
    public String getMongoPassword() {
        return this.get(MONGO_USER_PASSWORD);
    }

    public String getRyaInstanceName() {
        return this.get(MONGO_COLLECTION_PREFIX, "rya");
    }

    public void setRyaInstanceName(String name) {
        Objects.requireNonNull(name);
        this.set(MONGO_COLLECTION_PREFIX, name);
    }

    public String getTriplesCollectionName() {
        return this.getRyaInstanceName() + "_triples";
    }

    public String getNameSpacesCollectionName() {
        return this.getRyaInstanceName() + "_ns";
    }

    public Authorizations getAuthorizations() {
        String[] auths = this.getAuths();
        if (auths == null || auths.length == 0) {
            return MongoDbRdfConstants.ALL_AUTHORIZATIONS;
        }
        return new Authorizations(auths);
    }

    public boolean flushEachUpdate() {
        return this.getBoolean(CONF_FLUSH_EACH_UPDATE, true);
    }

    public void setFlush(boolean flush) {
        this.setBoolean(CONF_FLUSH_EACH_UPDATE, flush);
    }

    public boolean getUseAggregationPipeline() {
        return this.getBoolean(USE_AGGREGATION_PIPELINE, false);
    }

    public void setUseAggregationPipeline(boolean value) {
        this.setBoolean(USE_AGGREGATION_PIPELINE, value);
    }

    public List<Class<QueryOptimizer>> getOptimizers() {
        List optimizers = super.getOptimizers();
        if (this.getUseAggregationPipeline()) {
            Class<AggregationPipelineQueryOptimizer> cl;
            Class<AggregationPipelineQueryOptimizer> optCl = cl = AggregationPipelineQueryOptimizer.class;
            optimizers.add(optCl);
        }
        return optimizers;
    }
}

