/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.persist.query.BatchRyaQuery;
import org.apache.rya.api.persist.query.RyaQuery;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.dao.MongoDBStorageStrategy;
import org.apache.rya.mongodb.dao.SimpleMongoDBStorageStrategy;
import org.apache.rya.mongodb.iter.RyaStatementBindingSetCursorIterator;
import org.apache.rya.mongodb.iter.RyaStatementCursorIterator;
import org.bson.Document;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

public class MongoDBQueryEngine
implements RyaQueryEngine<StatefulMongoDBRdfConfiguration> {
    private StatefulMongoDBRdfConfiguration configuration;
    private final MongoDBStorageStrategy<RyaStatement> strategy = new SimpleMongoDBStorageStrategy();

    public void setConf(StatefulMongoDBRdfConfiguration conf) {
        this.configuration = conf;
    }

    public StatefulMongoDBRdfConfiguration getConf() {
        return this.configuration;
    }

    public CloseableIteration<RyaStatement, RyaDAOException> query(RyaStatement stmt, StatefulMongoDBRdfConfiguration conf) throws RyaDAOException {
        Preconditions.checkNotNull((Object)stmt);
        Preconditions.checkNotNull((Object)((Object)conf));
        AbstractMap.SimpleEntry<RyaStatement, MapBindingSet> entry = new AbstractMap.SimpleEntry<RyaStatement, MapBindingSet>(stmt, new MapBindingSet());
        Set<Map.Entry<RyaStatement, BindingSet>> collection = Collections.singleton(entry);
        return new RyaStatementCursorIterator(this.queryWithBindingSet(collection, conf));
    }

    public CloseableIteration<? extends Map.Entry<RyaStatement, BindingSet>, RyaDAOException> queryWithBindingSet(Collection<Map.Entry<RyaStatement, BindingSet>> stmts, StatefulMongoDBRdfConfiguration conf) throws RyaDAOException {
        Preconditions.checkNotNull(stmts);
        Preconditions.checkNotNull((Object)((Object)conf));
        HashMultimap rangeMap = HashMultimap.create();
        try {
            for (Map.Entry<RyaStatement, BindingSet> stmtbs : stmts) {
                RyaStatement stmt = stmtbs.getKey();
                BindingSet bs = stmtbs.getValue();
                rangeMap.put((Object)stmt, (Object)bs);
            }
            RyaStatementBindingSetCursorIterator iterator = new RyaStatementBindingSetCursorIterator(this.getCollection(conf), (Multimap<RyaStatement, BindingSet>)rangeMap, this.strategy, conf.getAuthorizations());
            return iterator;
        }
        catch (Exception e) {
            throw new RyaDAOException((Throwable)e);
        }
    }

    public CloseableIteration<RyaStatement, RyaDAOException> batchQuery(Collection<RyaStatement> stmts, StatefulMongoDBRdfConfiguration conf) throws RyaDAOException {
        HashMap<RyaStatement, MapBindingSet> queries = new HashMap<RyaStatement, MapBindingSet>();
        for (RyaStatement stmt : stmts) {
            queries.put(stmt, new MapBindingSet());
        }
        return new RyaStatementCursorIterator(this.queryWithBindingSet(queries.entrySet(), conf));
    }

    public CloseableIterable<RyaStatement> query(RyaQuery ryaQuery) throws RyaDAOException {
        Preconditions.checkNotNull((Object)ryaQuery);
        return this.query(new BatchRyaQuery(Collections.singleton(ryaQuery.getQuery())));
    }

    public CloseableIterable<RyaStatement> query(BatchRyaQuery batchRyaQuery) throws RyaDAOException {
        Preconditions.checkNotNull((Object)batchRyaQuery);
        HashMap<RyaStatement, MapBindingSet> queries = new HashMap<RyaStatement, MapBindingSet>();
        for (RyaStatement stmt : batchRyaQuery.getQueries()) {
            queries.put(stmt, new MapBindingSet());
        }
        RyaStatementCursorIterator iterator = new RyaStatementCursorIterator(this.queryWithBindingSet(queries.entrySet(), this.getConf()));
        return CloseableIterables.wrap(() -> iterator);
    }

    private MongoCollection<Document> getCollection(StatefulMongoDBRdfConfiguration conf) {
        MongoDatabase db = conf.getMongoClient().getDatabase(conf.getMongoDBName());
        return db.getCollection(conf.getTriplesCollectionName());
    }

    public void close() throws IOException {
    }
}

