/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.mongodb;

import org.apache.rya.api.RdfCloudTripleStoreConfigurationBuilder;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;

public abstract class AbstractMongoDBRdfConfigurationBuilder<B extends AbstractMongoDBRdfConfigurationBuilder<B, C>, C extends MongoDBRdfConfiguration>
extends RdfCloudTripleStoreConfigurationBuilder<B, C> {
    private String user;
    private String pass;
    private boolean useMock = false;
    private String host = "localhost";
    private String port = "27017";
    public static final String DEFAULT_MONGO_PORT = "27017";
    private String mongoCollectionPrefix = "rya_";
    private String mongoDBName = "rya";
    private boolean usePipeline = false;
    public static final String MONGO_USER = "mongo.user";
    public static final String MONGO_PASSWORD = "mongo.password";
    public static final String MONGO_DB_NAME = "mongo.db.name";
    public static final String MONGO_COLLECTION_PREFIX = "mongo.collection.prefix";
    public static final String MONGO_HOST = "mongo.host";
    public static final String MONGO_PORT = "mongo.port";
    public static final String MONGO_AUTHS = "mongo.auths";
    public static final String MONGO_VISIBILITIES = "mongo.visibilities";
    public static final String MONGO_RYA_PREFIX = "mongo.rya.prefix";
    public static final String USE_INFERENCE = "use.inference";
    public static final String USE_DISPLAY_QUERY_PLAN = "use.display.plan";
    public static final String USE_MOCK_MONGO = "use.mock";

    public B setMongoUser(String user) {
        this.user = user;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setMongoPassword(String password) {
        this.pass = password;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setMongoPort(String port) {
        this.port = port;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setMongoHost(String host) {
        this.host = host;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setMongoDBName(String name) {
        this.mongoDBName = name;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setMongoCollectionPrefix(String prefix) {
        this.mongoCollectionPrefix = prefix;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setUseMockMongo(boolean useMock) {
        this.useMock = useMock;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public B setUseAggregationPipeline(boolean usePipeline) {
        this.usePipeline = usePipeline;
        return (B)((Object)((AbstractMongoDBRdfConfigurationBuilder)this.confBuilder()));
    }

    public C build() {
        return (C)((Object)this.getConf((MongoDBRdfConfiguration)super.build()));
    }

    private C getConf(C conf) {
        ((MongoDBRdfConfiguration)((Object)conf)).setUseMock(this.useMock);
        conf.set("sc.useMongo", "true");
        if (this.user != null) {
            ((MongoDBRdfConfiguration)((Object)conf)).setMongoUser(this.user);
        }
        if (this.pass != null) {
            ((MongoDBRdfConfiguration)((Object)conf)).setMongoPassword(this.pass);
        }
        ((MongoDBRdfConfiguration)((Object)conf)).setMongoDBName(this.mongoDBName);
        ((MongoDBRdfConfiguration)((Object)conf)).setRyaInstanceName(this.mongoCollectionPrefix);
        conf.setTablePrefix(this.mongoCollectionPrefix);
        ((MongoDBRdfConfiguration)((Object)conf)).setMongoHostname(this.host);
        ((MongoDBRdfConfiguration)((Object)conf)).setMongoPort(this.port);
        ((MongoDBRdfConfiguration)((Object)conf)).setUseAggregationPipeline(this.usePipeline);
        return conf;
    }
}

