/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.camel.cbsail;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.rya.camel.cbsail.CbSailComponent;
import org.apache.rya.camel.cbsail.CbSailEndpoint;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class CbSailProducer
extends DefaultProducer {
    private RepositoryConnection connection;
    private final CbSailEndpoint.CbSailOutput queryOutput = CbSailEndpoint.CbSailOutput.BINARY;

    public CbSailProducer(CbSailEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Collection<String> queries = new ArrayList();
        Collection tmp = (Collection)exchange.getIn().getHeader("cbsail.sparql", Collection.class);
        if (tmp != null) {
            queries = tmp;
        } else {
            String query = (String)exchange.getIn().getHeader("cbsail.sparql", String.class);
            if (query != null) {
                queries.add(query);
            }
        }
        if (queries.size() > 0) {
            this.sparqlQuery(exchange, queries);
        } else {
            this.inputTriples(exchange);
        }
    }

    protected void inputTriples(Exchange exchange) throws RepositoryException {
        Object body = exchange.getIn().getBody();
        if (body instanceof Statement) {
            this.inputStatement((Statement)body);
        } else if (body instanceof List) {
            List lst = (List)body;
            for (Object obj : lst) {
                if (!(obj instanceof Statement)) continue;
                this.inputStatement((Statement)obj);
            }
        }
        this.connection.commit();
        exchange.getOut().setBody((Object)Boolean.TRUE);
    }

    protected void inputStatement(Statement stmt) throws RepositoryException {
        this.connection.add(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), new Resource[0]);
    }

    protected void sparqlQuery(Exchange exchange, Collection<String> queries) throws RepositoryException, MalformedQueryException, QueryEvaluationException, TupleQueryResultHandlerException, RDFHandlerException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String query : queries) {
            String auth = (String)exchange.getIn().getHeader("query.auth", String.class);
            Boolean infer = (Boolean)exchange.getIn().getHeader("query.infer", Boolean.class);
            Object output = this.performSelect(query, auth, infer);
            if (queries.size() == 1) {
                exchange.getOut().setBody(output);
                return;
            }
            list.add(output);
        }
        exchange.getOut().setBody(list);
    }

    protected Object performSelect(String query, String auth, Boolean infer) throws RepositoryException, MalformedQueryException, QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQuery tupleQuery = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, query);
        if (auth != null && auth.length() > 0) {
            tupleQuery.setBinding("query.auth", (Value)CbSailComponent.VALUE_FACTORY.createLiteral(auth));
        }
        if (infer != null) {
            tupleQuery.setBinding("query.infer", (Value)CbSailComponent.VALUE_FACTORY.createLiteral(infer.booleanValue()));
        }
        if (CbSailEndpoint.CbSailOutput.BINARY.equals((Object)this.queryOutput)) {
            final ArrayList listOutput = new ArrayList();
            AbstractTupleQueryResultHandler handler = new AbstractTupleQueryResultHandler(){

                public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String s : bindingSet.getBindingNames()) {
                        map.put(s, bindingSet.getBinding(s).getValue().stringValue());
                    }
                    listOutput.add(map);
                }
            };
            tupleQuery.evaluate((TupleQueryResultHandler)handler);
            return listOutput;
        }
        if (CbSailEndpoint.CbSailOutput.XML.equals((Object)this.queryOutput)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SPARQLResultsXMLWriter sparqlWriter = new SPARQLResultsXMLWriter((OutputStream)baos);
            tupleQuery.evaluate((TupleQueryResultHandler)sparqlWriter);
            return new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Query Output[" + (Object)((Object)this.queryOutput) + "] is not recognized");
    }

    protected void doStart() throws Exception {
        CbSailEndpoint cbSailEndpoint = (CbSailEndpoint)this.getEndpoint();
        this.connection = cbSailEndpoint.getSailRepository().getConnection();
    }

    protected void doStop() throws Exception {
        this.connection.close();
    }
}

