/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.camel.cbsail;

import com.google.common.base.Preconditions;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.rya.camel.cbsail.CbSailProducer;
import org.eclipse.rdf4j.repository.Repository;

public class CbSailEndpoint
extends DefaultEndpoint {
    private Long ttl;
    private Repository sailRepository;
    private String sparql;
    private String tablePrefix;
    private boolean infer = true;
    private String queryOutput = CbSailOutput.BINARY.toString();

    public CbSailEndpoint(String endpointUri, Component component, Repository sailRepository, String remaining) {
        super(endpointUri, component);
        this.sailRepository = sailRepository;
    }

    protected void validate() {
        Preconditions.checkNotNull((Object)this.sailRepository);
    }

    public Producer createProducer() throws Exception {
        this.validate();
        return new CbSailProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume from a CbSailEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public String getSparql() {
        return this.sparql;
    }

    public void setSparql(String sparql) {
        this.sparql = sparql;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public boolean isInfer() {
        return this.infer;
    }

    public void setInfer(boolean infer) {
        this.infer = infer;
    }

    public String getQueryOutput() {
        return this.queryOutput;
    }

    public void setQueryOutput(String queryOutput) {
        this.queryOutput = queryOutput;
    }

    public Repository getSailRepository() {
        return this.sailRepository;
    }

    public void setSailRepository(Repository sailRepository) {
        this.sailRepository = sailRepository;
    }

    public static enum CbSailOutput {
        XML,
        BINARY;

    }
}

