/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.camel.cbsail;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.rya.camel.cbsail.CbSailEndpoint;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;

public class CbSailComponent
extends DefaultComponent {
    public static final String SAILREPONAME = "sailRepoName";
    public static final String ENDPOINT_URI = "cbsail";
    public static final String SPARQL_QUERY_PROP = "cbsail.sparql";
    public static final String START_TIME_QUERY_PROP = "cbsail.startTime";
    public static final String TTL_QUERY_PROP = "cbsail.ttl";
    public static final ValueFactory VALUE_FACTORY = SimpleValueFactory.getInstance();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String sailRepoNameParam = Repository.class.getName();
        if (parameters.containsKey(sailRepoNameParam)) {
            sailRepoNameParam = (String)this.getAndRemoveParameter(parameters, SAILREPONAME, String.class);
        }
        Repository sailRepository = (Repository)this.getCamelContext().getRegistry().lookup(sailRepoNameParam, Repository.class);
        Preconditions.checkNotNull((Object)sailRepository, (Object)("Sail Repository must exist within the camel registry. Using lookup name[" + sailRepoNameParam + "]"));
        CbSailEndpoint sailEndpoint = new CbSailEndpoint(uri, (Component)this, sailRepository, remaining);
        this.setProperties((Object)sailEndpoint, parameters);
        return sailEndpoint;
    }
}

